/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.DependenciesLockFile;
import se.vandmo.dependencylock.maven.LockedDependencies;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.TEST)
public final class CheckMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="dependencies-lock.json")
    private String filename;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifacts actualDependencies;
        DependenciesLockFile lockFile = DependenciesLockFile.fromBasedir(this.basedir, this.filename);
        if (!lockFile.exists()) {
            this.getLog().error((CharSequence)"No lock file found, create one by running 'mvn se.vandmo:dependency-lock-maven-plugin:lock'");
            return;
        }
        LockedDependencies lockedDependencies = lockFile.read();
        LockedDependencies.Diff diff = lockedDependencies.compareWith(actualDependencies = Artifacts.from(this.project.getArtifacts()), this.project.getVersion());
        if (!diff.equals()) {
            diff.logTo(this.getLog());
            throw new MojoExecutionException("Dependencies differ");
        }
        this.getLog().info((CharSequence)"Actual dependencies matches locked dependencies");
    }
}

