/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import se.vandmo.dependencylock.maven.JsonUtils;
import se.vandmo.dependencylock.maven.LockedDependencies;

public final class DependenciesLockFile {
    public static final String DEFAULT_FILENAME = "dependencies-lock.json";
    private final File file;

    private DependenciesLockFile(File file) {
        this.file = file;
    }

    public static DependenciesLockFile fromBasedir(File basedir, String filename) {
        return new DependenciesLockFile(new File(basedir, filename));
    }

    public LockedDependencies read() {
        JsonNode json = JsonUtils.readJson(this.file);
        if (!json.isObject()) {
            throw new IllegalStateException("Expected top level type to be an object");
        }
        JsonNode dependencies = json.get("dependencies");
        if (dependencies == null || !dependencies.isArray()) {
            throw new IllegalStateException("Expected a property named 'dependencies' of type array");
        }
        return LockedDependencies.fromJson(dependencies);
    }

    public void write(LockedDependencies lockedDependencies) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.set("dependencies", lockedDependencies.asJson());
        JsonUtils.writeJson(this.file, (JsonNode)json);
    }

    public void format() {
        this.write(this.read());
    }

    public boolean exists() {
        return this.file.exists();
    }
}

