/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.mojo.settings;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.sonatype.maven.mojo.settings.Clone;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public class MavenSettings {
    private MavenSettings() {
    }

    public static Server selectServer(Settings settings, String serverId) {
        Server server = settings.getServer(serverId);
        if (server != null) {
            return Clone.copy(server);
        }
        return null;
    }

    public static Proxy selectProxy(Settings settings, String serverUrl) throws MalformedURLException {
        URL url = new URL(serverUrl);
        String host = url.getHost();
        Proxy httpProxy = null;
        Proxy httpsProxy = null;
        List proxies = settings.getProxies();
        for (Proxy proxy : proxies) {
            if (!proxy.isActive() || MavenSettings.isNonProxyHosts(host, proxy.getNonProxyHosts())) continue;
            if ("http".equalsIgnoreCase(proxy.getProtocol()) && httpProxy == null) {
                httpProxy = proxy;
                continue;
            }
            if (!"https".equalsIgnoreCase(proxy.getProtocol()) || httpsProxy != null) continue;
            httpsProxy = proxy;
        }
        Proxy proxy = httpProxy;
        if ("https".equalsIgnoreCase(url.getProtocol()) && httpsProxy != null) {
            proxy = httpsProxy;
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server decrypt(SecDispatcher secDispatcher, Server server) throws SecDispatcherException {
        Server result = Clone.copy(server);
        SecDispatcher secDispatcher2 = secDispatcher;
        synchronized (secDispatcher2) {
            result.setUsername(MavenSettings.decrypt(secDispatcher, server.getUsername()));
            result.setPassword(MavenSettings.decrypt(secDispatcher, server.getPassword()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Proxy decrypt(SecDispatcher secDispatcher, Proxy server) throws SecDispatcherException {
        Proxy result = Clone.copy(server);
        SecDispatcher secDispatcher2 = secDispatcher;
        synchronized (secDispatcher2) {
            result.setUsername(MavenSettings.decrypt(secDispatcher, server.getUsername()));
            result.setPassword(MavenSettings.decrypt(secDispatcher, server.getPassword()));
        }
        return result;
    }

    private static boolean isNonProxyHosts(String host, String nonProxyHosts) {
        if (host != null && nonProxyHosts != null && nonProxyHosts.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                if (!host.matches(pattern = pattern.replace(".", "\\.").replace("*", ".*"))) continue;
                return true;
            }
        }
        return false;
    }

    private static String decrypt(SecDispatcher secDispatcher, String str) throws SecDispatcherException {
        if (secDispatcher == null) {
            return str;
        }
        return secDispatcher.decrypt(str);
    }
}

