/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.staging.client.internal;

import com.sonatype.nexus.staging.api.dto.StagingRuleDTO;
import com.sonatype.nexus.staging.api.dto.StagingRulePropertyDTO;
import com.sonatype.nexus.staging.api.dto.StagingRuleSetDTO;
import com.sonatype.nexus.staging.api.dto.StagingRuleSetRequestDTO;
import com.sonatype.nexus.staging.api.dto.StagingRuleSetResponseDTO;
import com.sonatype.nexus.staging.client.StagingRuleSet;
import com.sonatype.nexus.staging.client.internal.JerseyStagingRuleSets;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.JerseyEntitySupport;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public class JerseyStagingRuleSet
extends JerseyEntitySupport<StagingRuleSet, StagingRuleSetDTO>
implements StagingRuleSet {
    public JerseyStagingRuleSet(JerseyNexusClient nexusClient) {
        super(nexusClient, null);
    }

    public JerseyStagingRuleSet(JerseyNexusClient nexusClient, StagingRuleSetDTO settings) {
        super(nexusClient, settings.getId(), (Object)settings);
    }

    protected StagingRuleSetDTO createSettings(String id) {
        StagingRuleSetDTO settings = new StagingRuleSetDTO();
        settings.setId(id);
        return settings;
    }

    public String id() {
        return ((StagingRuleSetDTO)this.settings()).getId();
    }

    protected StagingRuleSetDTO doGet() {
        try {
            return ((StagingRuleSetResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyStagingRuleSets.path(this.id())).get(StagingRuleSetResponseDTO.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    protected StagingRuleSetDTO doCreate() {
        StagingRuleSetRequestDTO request = new StagingRuleSetRequestDTO();
        request.setData((StagingRuleSetDTO)this.settings());
        try {
            return ((StagingRuleSetResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource("staging/rule_sets").post(StagingRuleSetResponseDTO.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    protected StagingRuleSetDTO doUpdate() {
        StagingRuleSetRequestDTO request = new StagingRuleSetRequestDTO();
        request.setData((StagingRuleSetDTO)this.settings());
        try {
            return ((StagingRuleSetResponseDTO)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyStagingRuleSets.path(this.id())).put(StagingRuleSetResponseDTO.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert((UniformInterfaceException)((Object)new JerseyStagingRuleSets.StagingRuleSetNotFoundException(e.getResponse(), this.id())));
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    protected void doRemove() {
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyStagingRuleSets.path(this.id())).delete();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert((UniformInterfaceException)((Object)new JerseyStagingRuleSets.StagingRuleSetNotFoundException(e.getResponse(), this.id())));
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public String name() {
        return ((StagingRuleSetDTO)this.settings()).getName();
    }

    @Override
    public String description() {
        return ((StagingRuleSetDTO)this.settings()).getDescription();
    }

    @Override
    public List<StagingRuleDTO> stagingRules() {
        return Collections.unmodifiableList(((StagingRuleSetDTO)this.settings()).getRules());
    }

    @Override
    public JerseyStagingRuleSet withName(String name) {
        ((StagingRuleSetDTO)this.settings()).setName(name);
        return this;
    }

    @Override
    public JerseyStagingRuleSet withDescription(String description) {
        ((StagingRuleSetDTO)this.settings()).setDescription(description);
        return this;
    }

    @Override
    public JerseyStagingRuleSet withStagingRules(StagingRuleDTO ... stagingRules) {
        if (stagingRules != null) {
            ((StagingRuleSetDTO)this.settings()).setRules(Arrays.asList(stagingRules));
        } else {
            ((StagingRuleSetDTO)this.settings()).getRules().clear();
        }
        return this;
    }

    @Override
    public JerseyStagingRuleSet addStagingRules(StagingRuleDTO ... stagingRules) {
        if (stagingRules != null) {
            for (StagingRuleDTO stagingRule : stagingRules) {
                ((StagingRuleSetDTO)this.settings()).addRule(stagingRule);
            }
        }
        return this;
    }

    @Override
    public JerseyStagingRuleSet removeStagingRules(StagingRuleDTO ... stagingRules) {
        if (stagingRules != null) {
            for (StagingRuleDTO stagingRule : stagingRules) {
                ((StagingRuleSetDTO)this.settings()).getRules().remove(stagingRule);
            }
        }
        return this;
    }

    @Override
    public StagingRuleDTO createStagingRule(String name, String typeId, boolean enabled, StagingRulePropertyDTO ... properties) {
        StagingRuleDTO stagingRuleDTO = new StagingRuleDTO();
        stagingRuleDTO.setName(name);
        stagingRuleDTO.setTypeId(typeId);
        stagingRuleDTO.setEnabled(enabled);
        if (properties != null) {
            stagingRuleDTO.setProperties(Arrays.asList(properties));
        }
        return stagingRuleDTO;
    }
}

