/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy.strategy;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.sonatype.nexus.staging.api.dto.StagingActionDTO;
import com.sonatype.nexus.staging.client.Profile;
import com.sonatype.nexus.staging.client.StagingRuleFailuresException;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import com.sonatype.nexus.staging.client.StagingWorkflowV3Service;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.nexus.client.core.exception.NexusClientAccessForbiddenException;
import org.sonatype.nexus.client.core.exception.NexusClientErrorResponseException;
import org.sonatype.nexus.client.core.exception.NexusClientNotFoundException;
import org.sonatype.nexus.maven.staging.ErrorDumper;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.deploy.DeployableArtifact;
import org.sonatype.nexus.maven.staging.deploy.StagingRepository;
import org.sonatype.nexus.maven.staging.deploy.strategy.AbstractStagingDeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployPerModuleRequest;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.FinalizeDeployRequest;
import org.sonatype.nexus.maven.staging.remote.Parameters;
import org.sonatype.nexus.maven.staging.remote.RemoteNexus;

@Component(role=DeployStrategy.class, hint="staging")
public class StagingDeployStrategy
extends AbstractStagingDeployStrategy {
    @Override
    public void deployPerModule(DeployPerModuleRequest request) throws ArtifactInstallationException, ArtifactDeploymentException, MojoExecutionException {
        this.log.info("Performing local staging (local stagingDirectory=\"{}\")...", (Object)request.getParameters().getStagingDirectoryRoot().getAbsolutePath());
        if (!request.getDeployableArtifacts().isEmpty()) {
            RemoteNexus remoteNexus = this.createRemoteNexus(request.getMavenSession(), request.getParameters());
            request.setRemoteNexus(remoteNexus);
            String profileId = this.selectStagingProfile(request.getParameters(), remoteNexus, request.getDeployableArtifacts().get(0).getArtifact());
            File stagingDirectory = this.getStagingDirectory(request.getParameters().getStagingDirectoryRoot(), profileId);
            for (DeployableArtifact deployableArtifact : request.getDeployableArtifacts()) {
                ArtifactRepository stagingRepository = this.getArtifactRepositoryForDirectory(stagingDirectory);
                this.install(deployableArtifact.getFile(), deployableArtifact.getArtifact(), stagingRepository, stagingDirectory, null);
            }
        } else {
            this.log.info("Nothing to locally stage?");
        }
    }

    @Override
    public void finalizeDeploy(FinalizeDeployRequest request) throws ArtifactDeploymentException, MojoExecutionException {
        this.log.info("Performing remote staging...");
        File stageRoot = request.getParameters().getStagingDirectoryRoot();
        File[] localStageRepositories = stageRoot.listFiles();
        if (localStageRepositories == null) {
            this.log.info("We have nothing locally staged, bailing out.");
            return;
        }
        if (request.getRemoteNexus() == null) {
            request.setRemoteNexus(this.createRemoteNexus(request.getMavenSession(), request.getParameters()));
        }
        RemoteNexus remoteNexus = request.getRemoteNexus();
        ArrayList<StagingRepository> zappedStagingRepositories = new ArrayList<StagingRepository>();
        for (File profileDirectory : localStageRepositories) {
            if (!profileDirectory.isDirectory()) continue;
            String profileId = profileDirectory.getName();
            this.log.info("");
            this.log.info(" * Remote staging into staging profile ID \"{}\"", (Object)profileId);
            try {
                Profile stagingProfile = remoteNexus.getStagingWorkflowV2Service().selectProfile(profileId);
                StagingRepository stagingRepository = this.beforeUpload(request.getParameters(), remoteNexus, stagingProfile);
                zappedStagingRepositories.add(stagingRepository);
                this.log.info(" * Uploading locally staged artifacts to profile {}", (Object)stagingProfile.name());
                this.deployUp(request.getMavenSession(), this.getStagingDirectory(request.getParameters().getStagingDirectoryRoot(), profileId), this.createDeploymentArtifactRepository(remoteNexus.getServer().getId(), stagingRepository.getUrl()));
                this.log.info(" * Upload of locally staged artifacts finished.");
                this.afterUpload(request.getParameters(), remoteNexus, stagingRepository);
            }
            catch (NexusClientNotFoundException e) {
                this.afterUploadFailure(request.getParameters(), remoteNexus, zappedStagingRepositories, e);
                this.log.error("Remote staging finished with a failure: {}", (Object)e.getMessage());
                this.log.error("");
                this.log.error("Possible causes of 404 Not Found error:");
                this.log.error(" * your local workspace is \"dirty\" with previous runs, that locally staged artifacts? Run \"mvn clean\"...");
                this.log.error(" * remote Nexus got the profile with ID \"{}\" removed during this build? Get to Nexus admin...", (Object)profileId);
                throw new ArtifactDeploymentException("Remote staging failed: " + e.getMessage(), (Throwable)e);
            }
            catch (NexusClientAccessForbiddenException e) {
                this.afterUploadFailure(request.getParameters(), remoteNexus, zappedStagingRepositories, e);
                this.log.error("Remote staging finished with a failure: {}", (Object)e.getMessage());
                this.log.error("");
                this.log.error("Possible causes of 403 Forbidden:");
                this.log.error(" * you have no permissions to stage against profile with ID \"{}\"? Get to Nexus admin...", (Object)profileId);
                throw new ArtifactDeploymentException("Remote staging failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.afterUploadFailure(request.getParameters(), remoteNexus, zappedStagingRepositories, e);
                this.log.error("Remote staging finished with a failure: {}", (Object)e.getMessage());
                throw new ArtifactDeploymentException("Remote staging failed: " + e.getMessage(), (Throwable)e);
            }
        }
        this.log.info("Remote staged {} repositories, finished with success.", (Object)zappedStagingRepositories.size());
        if (!request.getParameters().isSkipStagingRepositoryClose() && request.getParameters().isAutoReleaseAfterClose()) {
            this.releaseAfterClose(request.getParameters(), remoteNexus, zappedStagingRepositories);
        }
    }

    protected void releaseAfterClose(Parameters parameters, RemoteNexus remoteNexus, List<StagingRepository> stagedRepositories) throws MojoExecutionException {
        this.log.info("Remote staging repositories are being released...");
        ArrayList stagedRepositoryIds = Lists.newArrayList((Iterable)Collections2.transform(stagedRepositories, (Function)new Function<StagingRepository, String>(){

            public String apply(StagingRepository input) {
                return input.getRepositoryId();
            }
        }));
        StagingWorkflowV2Service stagingWorkflow = remoteNexus.getStagingWorkflowV2Service();
        try {
            if (stagingWorkflow instanceof StagingWorkflowV3Service) {
                StagingWorkflowV3Service v3 = (StagingWorkflowV3Service)stagingWorkflow;
                StagingActionDTO action = new StagingActionDTO();
                action.setDescription(parameters.getActionDescription(StagingAction.RELEASE));
                action.setStagedRepositoryIds(stagedRepositoryIds);
                action.setAutoDropAfterRelease(parameters.isAutoDropAfterRelease());
                v3.releaseStagingRepositories(action);
            } else {
                stagingWorkflow.releaseStagingRepositories(parameters.getActionDescription(StagingAction.RELEASE), stagedRepositoryIds.toArray(new String[stagedRepositoryIds.size()]));
            }
        }
        catch (NexusClientErrorResponseException e) {
            ErrorDumper.dumpErrors(this.log, e);
            throw new MojoExecutionException("Could not perform action: Nexus ErrorResponse received!", (Exception)((Object)e));
        }
        catch (StagingRuleFailuresException e) {
            ErrorDumper.dumpErrors(this.log, e);
            throw new MojoExecutionException("Could not perform action: there are failing staging rules!", (Exception)((Object)e));
        }
        this.log.info("Remote staging repositories released.");
    }
}

