/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer.utils;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class NormalizeLineSeparatorReader
extends FilterReader {
    private static final int EOL = -1;
    final LineSeparator lineSeparator;
    Character bufferedCharacter;
    Character previousCharacter;

    public NormalizeLineSeparatorReader(Reader reader, LineSeparator lineSeparator) {
        super(reader);
        this.lineSeparator = lineSeparator;
        this.bufferedCharacter = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n;
        for (n = off; n < off + len; ++n) {
            int readResult = this.read();
            if (readResult == -1) {
                return n == 0 ? -1 : n;
            }
            cbuf[n] = (char)readResult;
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        if (this.bufferedCharacter != null) {
            char localBuffer = this.bufferedCharacter.charValue();
            this.bufferedCharacter = null;
            return localBuffer;
        }
        int readResult = super.read();
        if (readResult == -1) {
            return readResult;
        }
        char currentCharacter = (char)readResult;
        if (this.lineSeparator == LineSeparator.UNIX) {
            switch (LineSeparator.WINDOWS.matches(currentCharacter, this.previousCharacter)) {
                case MATCH: {
                    return this.lineSeparator.separatorChars[0];
                }
                case POTENTIAL_MATCH: {
                    this.previousCharacter = Character.valueOf(currentCharacter);
                    return this.read();
                }
            }
        } else {
            switch (LineSeparator.UNIX.matches(currentCharacter, this.previousCharacter)) {
                case MATCH: {
                    this.bufferedCharacter = Character.valueOf(this.lineSeparator.separatorChars[1]);
                    return this.lineSeparator.separatorChars[0];
                }
                case POTENTIAL_MATCH: {
                    throw new IllegalStateException("No potential matches expected for Unix line separator");
                }
            }
        }
        this.previousCharacter = Character.valueOf(currentCharacter);
        return currentCharacter;
    }

    public static enum LineSeparator {
        WINDOWS("\r\n", null),
        UNIX("\n", Character.valueOf('\r'));

        private final char[] separatorChars;
        private final Character notPrecededByChar;

        private LineSeparator(String separator, Character notPrecededByChar) {
            this.separatorChars = separator.toCharArray();
            this.notPrecededByChar = notPrecededByChar;
        }

        public MatchResult matches(char currentCharacter, Character previousCharacter) {
            int len = this.separatorChars.length;
            if (currentCharacter == this.separatorChars[len - 1]) {
                if (len > 1 && (previousCharacter == null || previousCharacter.charValue() != this.separatorChars[len - 1])) {
                    return MatchResult.NO_MATCH;
                }
                if (this.notPrecededByChar != null && previousCharacter != null && this.notPrecededByChar == previousCharacter) {
                    return MatchResult.NO_MATCH;
                }
                return MatchResult.MATCH;
            }
            if (len > 1 && currentCharacter == this.separatorChars[len - 2]) {
                return MatchResult.POTENTIAL_MATCH;
            }
            return MatchResult.NO_MATCH;
        }

        static enum MatchResult {
            NO_MATCH,
            POTENTIAL_MATCH,
            MATCH;

        }
    }
}

