/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.security.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public final class PgpHelper {
    private PgpHelper() {
    }

    public static InputStream fromString(String data) {
        return new ByteArrayInputStream(data.getBytes(StandardCharsets.US_ASCII));
    }

    public static Stream<PGPKeyRing> streamKeyring(InputStream input) throws IOException, PGPException {
        BcPGPSecretKeyRingCollection keyrings = new BcPGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input));
        Iterator keyRingIter = keyrings.getKeyRings();
        Stream<Object> s = StreamSupport.stream(Spliterators.spliteratorUnknownSize(keyRingIter, 16), false);
        return s.map(o -> (PGPKeyRing)o);
    }

    public static Stream<PGPSecretKeyRing> streamSecretKeyring(InputStream input) throws IOException, PGPException {
        Stream<PGPKeyRing> s = PgpHelper.streamKeyring(input);
        return s.filter(k -> k instanceof PGPSecretKeyRing).map(o -> (PGPSecretKeyRing)o);
    }

    public static Stream<PGPSecretKey> streamSecretKeys(InputStream input) throws IOException, PGPException {
        Stream<PGPSecretKeyRing> s = PgpHelper.streamSecretKeyring(input);
        return s.flatMap(k -> {
            Iterator i = k.getSecretKeys();
            Stream<Object> ks = StreamSupport.stream(Spliterators.spliteratorUnknownSize(i, 16), false);
            return ks.map(o -> (PGPSecretKey)o);
        });
    }

    public static String makeShortKey(PGPSecretKey key) {
        long shortId = key.getKeyID() & 0xFFFFFFFFL;
        return String.format("%08X", shortId);
    }

    public static Predicate<PGPSecretKey> keyShortId(String keyId) {
        final long keyIdNum = Long.parseUnsignedLong(keyId, 16);
        return new Predicate<PGPSecretKey>(){

            @Override
            public boolean test(PGPSecretKey key) {
                long shortId = key.getKeyID() & 0xFFFFFFFFL;
                return key.getKeyID() == keyIdNum || shortId == keyIdNum;
            }
        };
    }

    public static PGPPrivateKey loadPrivateKey(InputStream input, String keyId, String passPhrase) throws IOException, PGPException {
        return PgpHelper.loadPrivateKey(input, keyId, passPhrase != null ? passPhrase.toCharArray() : null);
    }

    public static PGPPrivateKey loadPrivateKey(InputStream input, String keyId, char[] passPhrase) throws IOException, PGPException {
        PGPSecretKey secretKey = PgpHelper.loadSecretKey(input, keyId);
        if (secretKey == null) {
            return null;
        }
        return secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passPhrase));
    }

    public static PGPSecretKey loadSecretKey(InputStream input, String keyId) throws IOException, PGPException {
        long keyIdNum = Long.parseUnsignedLong(keyId, 16);
        BcPGPSecretKeyRingCollection keyrings = new BcPGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input));
        Iterator keyRingIter = keyrings.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPSecretKeyRing secretKeyRing = (PGPSecretKeyRing)keyRingIter.next();
            Iterator secretKeyIterator = secretKeyRing.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)secretKeyIterator.next();
                if (!key.isSigningKey()) continue;
                long shortId = key.getKeyID() & 0xFFFFFFFFL;
                if (key.getKeyID() != keyIdNum && shortId != keyIdNum) continue;
                return key;
            }
        }
        return null;
    }
}

