/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OsType {
    MAC("Mac"),
    WINDOWS("Windows"),
    LINUX("Linux", "LINUX"),
    OTHER(new String[0]);

    private static final Logger log;
    private final String[] prefixes;

    static {
        log = LoggerFactory.getLogger(OsType.class);
    }

    private OsType(String ... prefixes) {
        this.prefixes = prefixes;
    }

    public static OsType detect() {
        String osName = System.getProperty("os.name");
        log.trace("OS name: {}", (Object)osName);
        OsType[] osTypeArray = OsType.values();
        int n = osTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OsType type = osTypeArray[n2];
            String[] stringArray = type.prefixes;
            int n3 = type.prefixes.length;
            int n4 = 0;
            while (n4 < n3) {
                String prefix = stringArray[n4];
                if (osName.startsWith(prefix)) {
                    return type;
                }
                ++n4;
            }
            ++n2;
        }
        return OTHER;
    }
}

