/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign.openpgp;

import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.simplify4u.plugins.sign.openpgp.PGPSignerException;
import org.simplify4u.plugins.sign.openpgp.PGPSignerKeyNotFoundException;

public class PGPKeyInfo {
    private static final String SIGN_KEY_ID_ENV = "SIGN_KEY_ID";
    private static final String SIGN_KEY_ENV = "SIGN_KEY";
    private static final String SIGN_KEY_PASS_ENV = "SIGN_KEY_PASS";
    private final Long id;
    private final char[] pass;
    private final InputStream key;

    private PGPKeyInfo(String keyId, String keyPass, File keyFile, UnaryOperator<String> passDecryptor) {
        this.id = Optional.ofNullable(PGPKeyInfo.stringFromEnv(SIGN_KEY_ID_ENV).orElse(keyId)).map(PGPKeyInfo::parseKeyId).orElse(null);
        this.pass = Optional.ofNullable(PGPKeyInfo.stringFromEnv(SIGN_KEY_PASS_ENV).orElse(keyPass)).map(Optional.ofNullable(passDecryptor).orElseGet(UnaryOperator::identity)).map(String::toCharArray).orElse(null);
        this.key = PGPKeyInfo.stringFromEnv(SIGN_KEY_ENV).map(String::trim).map(PGPKeyInfo::keyFromString).orElseGet(() -> PGPKeyInfo.keyFromFile(keyFile));
    }

    private static Optional<String> stringFromEnv(String environmentName) {
        return Optional.ofNullable(System.getenv(environmentName)).filter(s -> !"null".equals(s));
    }

    private static InputStream keyFromFile(File keyFile) {
        if (!keyFile.exists()) {
            throw new PGPSignerKeyNotFoundException("key file: " + keyFile + " not found");
        }
        return (InputStream)Try.of((CheckedFunction0 & Serializable)() -> Files.readAllBytes(keyFile.toPath())).map(ByteArrayInputStream::new).getOrElseThrow(PGPSignerException::new);
    }

    private static InputStream keyFromString(String key) {
        return new ByteArrayInputStream(key.getBytes(StandardCharsets.US_ASCII));
    }

    private static long parseKeyId(String key) {
        return (Long)Try.of((CheckedFunction0 & Serializable)() -> new BigInteger(key, 16)).map(BigInteger::longValue).getOrElseThrow(e -> new PGPSignerException("Invalid keyId: " + e.getMessage()));
    }

    @Generated
    public static PGPKeyInfoBuilder builder() {
        return new PGPKeyInfoBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public char[] getPass() {
        return this.pass;
    }

    @Generated
    public InputStream getKey() {
        return this.key;
    }

    @Generated
    public static class PGPKeyInfoBuilder {
        @Generated
        private String keyId;
        @Generated
        private String keyPass;
        @Generated
        private File keyFile;
        @Generated
        private UnaryOperator<String> passDecryptor;

        @Generated
        PGPKeyInfoBuilder() {
        }

        @Generated
        public PGPKeyInfoBuilder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        @Generated
        public PGPKeyInfoBuilder keyPass(String keyPass) {
            this.keyPass = keyPass;
            return this;
        }

        @Generated
        public PGPKeyInfoBuilder keyFile(File keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        @Generated
        public PGPKeyInfoBuilder passDecryptor(UnaryOperator<String> passDecryptor) {
            this.passDecryptor = passDecryptor;
            return this;
        }

        @Generated
        public PGPKeyInfo build() {
            return new PGPKeyInfo(this.keyId, this.keyPass, this.keyFile, this.passDecryptor);
        }

        @Generated
        public String toString() {
            return "PGPKeyInfo.PGPKeyInfoBuilder(keyId=" + this.keyId + ", keyPass=" + this.keyPass + ", keyFile=" + this.keyFile + ", passDecryptor=" + this.passDecryptor + ")";
        }
    }
}

