/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign.openpgp;

import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.simplify4u.plugins.sign.openpgp.PGPSignerException;

public final class PGPSecretKeyUtils {
    private PGPSecretKeyUtils() {
    }

    public static String getKeyId(PGPSecretKey secretKey) {
        return String.format("0x%016X", secretKey.getKeyID());
    }

    public static Collection<String> getUserIDs(PGPSecretKey secretKey, PGPSecretKeyRing secretKeyRing) {
        LinkedHashSet ret = new LinkedHashSet();
        secretKey.getPublicKey().getRawUserIDs().forEachRemaining(ret::add);
        PGPSecretKeyUtils.getMasterKey(secretKey, secretKeyRing).ifPresent(masterKey -> masterKey.getPublicKey().getRawUserIDs().forEachRemaining(ret::add));
        return ret.stream().map(b -> new String((byte[])b, StandardCharsets.UTF_8)).collect(Collectors.toSet());
    }

    public static String keyIdDescription(PGPSecretKey secretKey, PGPSecretKeyRing secretKeyRing) {
        Optional<PGPSecretKey> masterKey = PGPSecretKeyUtils.getMasterKey(secretKey, secretKeyRing);
        if (masterKey.isPresent()) {
            return String.format("SubKeyId: 0x%016X of %s", secretKey.getKeyID(), PGPSecretKeyUtils.fingerprint(masterKey.get()));
        }
        return "KeyId: " + PGPSecretKeyUtils.fingerprint(secretKey);
    }

    public static Optional<PGPSecretKey> getMasterKey(PGPSecretKey secretKey, PGPSecretKeyRing secretKeyRing) {
        if (secretKey.isMasterKey()) {
            return Optional.empty();
        }
        Iterable signatures = () -> secretKey.getPublicKey().getSignaturesOfType(24);
        return StreamSupport.stream(signatures.spliterator(), false).map(s -> secretKeyRing.getSecretKey(s.getKeyID())).findFirst();
    }

    public static String fingerprint(PGPSecretKey secretKey) {
        return PGPSecretKeyUtils.fingerprintToString(secretKey.getPublicKey().getFingerprint());
    }

    private static String fingerprintToString(byte[] bytes) {
        StringBuilder ret = new StringBuilder();
        ret.append("0x");
        for (byte b : bytes) {
            ret.append(String.format("%02X", b));
        }
        return ret.toString();
    }

    public static void verifyKeyExpiration(PGPSecretKey secretKey, PGPSecretKeyRing secretKeyRing) {
        long validSeconds = secretKey.getPublicKey().getValidSeconds();
        if (validSeconds > 0L) {
            LocalDateTime expireDateTime = secretKey.getPublicKey().getCreationTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime().plusSeconds(validSeconds);
            if (LocalDateTime.now().isAfter(expireDateTime)) {
                throw new PGPSignerException(PGPSecretKeyUtils.keyIdDescription(secretKey, secretKeyRing) + " was expired at: " + expireDateTime);
            }
        }
    }
}

