/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.plugins.sign.openpgp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import lombok.Generated;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.simplify4u.plugins.sign.openpgp.PGPKeyInfo;
import org.simplify4u.plugins.sign.openpgp.PGPSecretKeyUtils;
import org.simplify4u.plugins.sign.openpgp.PGPSignerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PGPSigner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPSigner.class);
    private PGPKeyInfo pgpKeyInfo;
    private PGPSecretKey secretKey;
    private PGPPrivateKey pgpPrivateKey;
    private PGPSignatureSubpacketVector hashSubPackets;
    private PGPSecretKeyRing secretKeyRing;

    PGPSigner() {
    }

    public void setKeyInfo(PGPKeyInfo keyInfo) {
        this.pgpKeyInfo = keyInfo;
        try {
            this.loadKey();
            this.prepareAdditionalSubPacket();
        }
        catch (IOException | PGPException e) {
            throw new PGPSignerException(e);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Loaded {}, uids: {}", (Object)PGPSecretKeyUtils.keyIdDescription(this.secretKey, this.secretKeyRing), PGPSecretKeyUtils.getUserIDs(this.secretKey, this.secretKeyRing));
        }
    }

    private void prepareAdditionalSubPacket() {
        PGPSignatureSubpacketGenerator subPacketGenerator = new PGPSignatureSubpacketGenerator();
        subPacketGenerator.setIssuerFingerprint(false, this.secretKey);
        this.hashSubPackets = subPacketGenerator.generate();
    }

    private void loadKey() throws IOException, PGPException {
        InputStream inputStream = PGPUtil.getDecoderStream((InputStream)this.pgpKeyInfo.getKey());
        PGPSecretKeyRingCollection pgpSecretKeyRingCollection = new PGPSecretKeyRingCollection(inputStream, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Long keyId = this.pgpKeyInfo.getId();
        Optional<PGPSecretKey> secretKeyOptional = keyId != null ? Optional.ofNullable(pgpSecretKeyRingCollection.getSecretKey(keyId.longValue())) : StreamSupport.stream(pgpSecretKeyRingCollection.spliterator(), false).flatMap(k -> StreamSupport.stream(k.spliterator(), false)).filter(key -> !key.isPrivateKeyEmpty()).findFirst();
        this.secretKey = secretKeyOptional.orElseThrow(() -> new PGPSignerException("Secret key not found"));
        this.secretKeyRing = pgpSecretKeyRingCollection.getSecretKeyRing(this.secretKey.getKeyID());
        if (this.secretKey.getKeyEncryptionAlgorithm() == 0 && this.pgpKeyInfo.getPass() != null) {
            LOGGER.warn("Plain secret key - password is not needed");
        }
        if (this.secretKey.getKeyEncryptionAlgorithm() != 0 && this.pgpKeyInfo.getPass() == null) {
            throw new PGPSignerException("Secret key is encrypted - keyPass is required");
        }
        if (this.secretKey.isPrivateKeyEmpty()) {
            throw new PGPSignerException("Private key not found for keyId: " + PGPSecretKeyUtils.getKeyId(this.secretKey));
        }
        PGPSecretKeyUtils.verifyKeyExpiration(this.secretKey, this.secretKeyRing);
        this.pgpPrivateKey = this.secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().build(this.pgpKeyInfo.getPass()));
    }

    public void sign(InputStream inputStream, Path outputPath) {
        PGPSignatureGenerator sGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(this.secretKey.getPublicKey().getAlgorithm(), 10));
        try {
            int len;
            sGen.init(0, this.pgpPrivateKey);
            sGen.setHashedSubpackets(this.hashSubPackets);
            byte[] buffer = new byte[8192];
            while ((len = inputStream.read(buffer)) >= 0) {
                sGen.update(buffer, 0, len);
            }
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(outputPath, new OpenOption[0]);
                 BCPGOutputStream bcpgOutputStream = new BCPGOutputStream((OutputStream)new ArmoredOutputStream(out));){
                sGen.generate().encode((OutputStream)bcpgOutputStream);
            }
        }
        catch (IOException | PGPException e) {
            throw new PGPSignerException(e);
        }
    }
}

