/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.shared.artifact.filter.StatisticsReportingArtifactFilter;
import org.codehaus.plexus.logging.Logger;

public class PatternIncludesArtifactFilter
implements ArtifactFilter,
StatisticsReportingArtifactFilter {
    private final Set<Pattern> patterns;
    private final Map<Integer, Map<String, Pattern>> simplePatterns;
    private final boolean actTransitively;
    private final Set<Pattern> patternsTriggered = new HashSet<Pattern>();
    private final List<Artifact> filteredArtifact = new ArrayList<Artifact>();
    private static final char[] EMPTY = new char[0];
    private static final char[] ANY = new char[]{'*'};

    public PatternIncludesArtifactFilter(Collection<String> patterns) {
        this(patterns, false);
    }

    public PatternIncludesArtifactFilter(Collection<String> patterns, boolean actTransitively) {
        this.actTransitively = actTransitively;
        LinkedHashSet<Pattern> pat = new LinkedHashSet<Pattern>();
        HashMap<Integer, HashMap<String, Pattern>> simplePat = null;
        boolean allPos = true;
        if (patterns != null && !patterns.isEmpty()) {
            for (String pattern : patterns) {
                Pattern p = PatternIncludesArtifactFilter.compile(pattern);
                allPos &= !(p instanceof NegativePattern);
                pat.add(p);
            }
        }
        if (allPos) {
            Iterator it = pat.iterator();
            while (it.hasNext()) {
                HashMap<String, Pattern> peqm;
                Pattern p = (Pattern)it.next();
                String peq = p.translateEquals();
                if (peq == null) continue;
                int nb = 0;
                for (char ch : peq.toCharArray()) {
                    if (ch != ':') continue;
                    ++nb;
                }
                if (simplePat == null) {
                    simplePat = new HashMap<Integer, HashMap<String, Pattern>>();
                }
                if ((peqm = (HashMap<String, Pattern>)simplePat.get(nb)) == null) {
                    peqm = new HashMap<String, Pattern>();
                    simplePat.put(nb, peqm);
                }
                peqm.put(peq, p);
                it.remove();
            }
        }
        this.simplePatterns = simplePat;
        this.patterns = pat;
    }

    public boolean include(Artifact artifact) {
        boolean shouldInclude = this.patternMatches(artifact);
        if (!shouldInclude) {
            this.addFilteredArtifact(artifact);
        }
        return shouldInclude;
    }

    protected boolean patternMatches(Artifact artifact) {
        List depTrail;
        char[][] artifactGatvCharArray = new char[][]{PatternIncludesArtifactFilter.emptyOrChars(artifact.getGroupId()), PatternIncludesArtifactFilter.emptyOrChars(artifact.getArtifactId()), PatternIncludesArtifactFilter.emptyOrChars(artifact.getType()), PatternIncludesArtifactFilter.emptyOrChars(artifact.getBaseVersion())};
        Boolean match = this.match(artifactGatvCharArray);
        if (match != null) {
            return match;
        }
        if (this.actTransitively && (depTrail = artifact.getDependencyTrail()) != null && depTrail.size() > 1) {
            for (String trailItem : depTrail) {
                char[][] depGatvCharArray = PatternIncludesArtifactFilter.tokenizeAndSplit(trailItem);
                match = this.match(depGatvCharArray);
                if (match == null) continue;
                return match;
            }
        }
        return false;
    }

    private Boolean match(char[][] gatvCharArray) {
        if (this.simplePatterns != null && this.simplePatterns.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                Pattern p;
                if (i > 0) {
                    sb.append(":");
                }
                sb.append(gatvCharArray[i]);
                Map<String, Pattern> map = this.simplePatterns.get(i);
                if (map == null || (p = map.get(sb.toString())) == null) continue;
                this.patternsTriggered.add(p);
                return true;
            }
        }
        for (Pattern pattern : this.patterns) {
            if (!pattern.matches(gatvCharArray)) continue;
            this.patternsTriggered.add(pattern);
            return !(pattern instanceof NegativePattern);
        }
        return null;
    }

    protected void addFilteredArtifact(Artifact artifact) {
        this.filteredArtifact.add(artifact);
    }

    @Override
    public void reportMissedCriteria(Logger logger) {
        if (!this.patterns.isEmpty()) {
            ArrayList<Pattern> missed = new ArrayList<Pattern>(this.patterns);
            missed.removeAll(this.patternsTriggered);
            if (!missed.isEmpty() && logger.isWarnEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("The following patterns were never triggered in this ");
                buffer.append(this.getFilterDescription());
                buffer.append(':');
                for (Pattern pattern : missed) {
                    buffer.append("\no  '").append(pattern).append("'");
                }
                buffer.append("\n");
                logger.warn(buffer.toString());
            }
        }
    }

    public String toString() {
        return "Includes filter:" + this.getPatternsAsString();
    }

    protected String getPatternsAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Pattern pattern : this.patterns) {
            buffer.append("\no '").append(pattern).append("'");
        }
        return buffer.toString();
    }

    protected String getFilterDescription() {
        return "artifact inclusion filter";
    }

    @Override
    public void reportFilteredArtifacts(Logger logger) {
        if (!this.filteredArtifact.isEmpty() && logger.isDebugEnabled()) {
            StringBuilder buffer = new StringBuilder("The following artifacts were removed by this " + this.getFilterDescription() + ": ");
            for (Artifact artifactId : this.filteredArtifact) {
                buffer.append('\n').append(artifactId.getId());
            }
            logger.debug(buffer.toString());
        }
    }

    @Override
    public boolean hasMissedCriteria() {
        if (!this.patterns.isEmpty()) {
            ArrayList<Pattern> missed = new ArrayList<Pattern>(this.patterns);
            missed.removeAll(this.patternsTriggered);
            return !missed.isEmpty();
        }
        return false;
    }

    static char[] emptyOrChars(String str) {
        return str != null && str.length() > 0 ? str.toCharArray() : EMPTY;
    }

    static char[] anyOrChars(char[] str) {
        return str.length > 1 || str.length == 1 && str[0] != '*' ? str : ANY;
    }

    static char[][] tokenizeAndSplit(String pattern) {
        String[] stokens = pattern.split(":");
        char[][] tokens = new char[stokens.length][];
        for (int i = 0; i < stokens.length; ++i) {
            tokens[i] = PatternIncludesArtifactFilter.emptyOrChars(stokens[i]);
        }
        return tokens;
    }

    static boolean match(char[] patArr, char[] strArr, boolean isVersion) {
        char ch;
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char aPatArr : patArr) {
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (isVersion && (patArr[0] == '[' || patArr[0] == '(')) {
                return PatternIncludesArtifactFilter.isVersionIncludedInRange(String.valueOf(strArr), String.valueOf(patArr));
            }
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || ch2 == strArr[i]) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (patArr[i] != '*') continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && ch != strArr[strIdxStart + i + j]) continue block8;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    static boolean isVersionIncludedInRange(String version, String range) {
        try {
            return VersionRange.createFromVersionSpec((String)range).containsVersion((ArtifactVersion)new DefaultArtifactVersion(version));
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }

    static Pattern compile(String pattern) {
        if (pattern.startsWith("!")) {
            return new NegativePattern(pattern, PatternIncludesArtifactFilter.compile(pattern.substring(1)));
        }
        char[][] stokens = PatternIncludesArtifactFilter.tokenizeAndSplit(pattern);
        char[][] tokens = new char[stokens.length][];
        for (int i = 0; i < stokens.length; ++i) {
            tokens[i] = PatternIncludesArtifactFilter.anyOrChars(stokens[i]);
        }
        if (tokens.length > 5) {
            throw new IllegalArgumentException("Invalid pattern: " + pattern);
        }
        if (tokens.length == 5) {
            if (tokens[3] != ANY) {
                throw new IllegalArgumentException("Invalid pattern: " + pattern);
            }
            tokens = new char[][]{tokens[0], tokens[1], tokens[2], tokens[4]};
        }
        if (tokens.length == 1) {
            if (tokens[0] == ANY) {
                return PatternIncludesArtifactFilter.all(pattern);
            }
            return PatternIncludesArtifactFilter.match(pattern, tokens[0], 0);
        }
        if (tokens.length == 2) {
            if (tokens[0] == ANY) {
                if (tokens[1] == ANY) {
                    return PatternIncludesArtifactFilter.all(pattern);
                }
                return PatternIncludesArtifactFilter.match(pattern, tokens[1], 0, 3);
            }
            if (tokens[1] == ANY) {
                return PatternIncludesArtifactFilter.match(pattern, tokens[0], 0);
            }
            Pattern m00 = PatternIncludesArtifactFilter.match(tokens[0], 0);
            Pattern m11 = PatternIncludesArtifactFilter.match(tokens[1], 1);
            return PatternIncludesArtifactFilter.and(pattern, m00, m11);
        }
        if (tokens.length == 3) {
            if (tokens[0] == ANY) {
                if (tokens[1] == ANY) {
                    if (tokens[2] == ANY) {
                        return PatternIncludesArtifactFilter.all(pattern);
                    }
                    return PatternIncludesArtifactFilter.match(pattern, tokens[2], 2, 3);
                }
                if (tokens[2] == ANY) {
                    return PatternIncludesArtifactFilter.match(pattern, tokens[1], 1, 2);
                }
                Pattern m11 = PatternIncludesArtifactFilter.match(tokens[1], 1);
                Pattern m12 = PatternIncludesArtifactFilter.match(tokens[1], 2);
                Pattern m22 = PatternIncludesArtifactFilter.match(tokens[2], 2);
                Pattern m23 = PatternIncludesArtifactFilter.match(tokens[2], 3);
                return PatternIncludesArtifactFilter.or(pattern, PatternIncludesArtifactFilter.and(m11, m22), PatternIncludesArtifactFilter.and(m12, m23));
            }
            if (tokens[1] == ANY) {
                if (tokens[2] == ANY) {
                    return PatternIncludesArtifactFilter.match(pattern, tokens[0], 0, 1);
                }
                Pattern m00 = PatternIncludesArtifactFilter.match(tokens[0], 0);
                Pattern m223 = PatternIncludesArtifactFilter.match(tokens[2], 2, 3);
                return PatternIncludesArtifactFilter.and(pattern, m00, m223);
            }
            if (tokens[2] == ANY) {
                Pattern m00 = PatternIncludesArtifactFilter.match(tokens[0], 0);
                Pattern m11 = PatternIncludesArtifactFilter.match(tokens[1], 1);
                return PatternIncludesArtifactFilter.and(pattern, m00, m11);
            }
            Pattern m00 = PatternIncludesArtifactFilter.match(tokens[0], 0);
            Pattern m11 = PatternIncludesArtifactFilter.match(tokens[1], 1);
            Pattern m22 = PatternIncludesArtifactFilter.match(tokens[2], 2);
            return PatternIncludesArtifactFilter.and(pattern, m00, m11, m22);
        }
        if (tokens.length == 4) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (int i = 0; i < 4; ++i) {
                if (tokens[i] == ANY) continue;
                patterns.add(PatternIncludesArtifactFilter.match(tokens[i], i));
            }
            return PatternIncludesArtifactFilter.and(pattern, patterns.toArray(new Pattern[0]));
        }
        throw new IllegalStateException();
    }

    private static Pattern match(String pattern, char[] token, int posVal) {
        return PatternIncludesArtifactFilter.match(pattern, token, posVal, posVal);
    }

    private static Pattern match(char[] token, int posVal) {
        return PatternIncludesArtifactFilter.match("", token, posVal, posVal);
    }

    private static Pattern match(String pattern, char[] token, int posMin, int posMax) {
        boolean hasWildcard = false;
        for (char ch : token) {
            if (ch != '*' && ch != '?') continue;
            hasWildcard = true;
            break;
        }
        if (hasWildcard || posMax == 3) {
            return new PosPattern(pattern, token, posMin, posMax);
        }
        return new EqPattern(pattern, token, posMin, posMax);
    }

    private static Pattern match(char[] token, int posMin, int posMax) {
        return new PosPattern("", token, posMin, posMax);
    }

    private static Pattern and(String pattern, Pattern ... patterns) {
        return new AndPattern(pattern, patterns);
    }

    private static Pattern and(Pattern ... patterns) {
        return PatternIncludesArtifactFilter.and("", patterns);
    }

    private static Pattern or(String pattern, Pattern ... patterns) {
        return new OrPattern(pattern, patterns);
    }

    private static Pattern or(Pattern ... patterns) {
        return PatternIncludesArtifactFilter.or("", patterns);
    }

    private static Pattern all(String pattern) {
        return new MatchAllPattern(pattern);
    }

    static class NegativePattern
    extends Pattern {
        private final Pattern inner;

        NegativePattern(String pattern, Pattern inner) {
            super(pattern);
            this.inner = inner;
        }

        @Override
        public boolean matches(char[][] parts) {
            return this.inner.matches(parts);
        }
    }

    static class MatchAllPattern
    extends Pattern {
        MatchAllPattern(String pattern) {
            super(pattern);
        }

        @Override
        public boolean matches(char[][] parts) {
            return true;
        }
    }

    static class EqPattern
    extends Pattern {
        private final char[] token;
        private final int posMin;
        private final int posMax;

        EqPattern(String pattern, char[] patternCharArray, int posMin, int posMax) {
            super(pattern);
            this.token = patternCharArray;
            this.posMin = posMin;
            this.posMax = posMax;
        }

        @Override
        public boolean matches(char[][] parts) {
            for (int i = this.posMin; i <= this.posMax; ++i) {
                if (!Arrays.equals(this.token, parts[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public String translateEquals() {
            return this.translateEquals(0);
        }

        @Override
        public String translateEquals(int pos) {
            return this.posMin == pos && this.posMax == pos && (pos < 3 || this.token[0] != '[' && this.token[0] != '(') ? String.valueOf(this.token) : null;
        }
    }

    static class PosPattern
    extends Pattern {
        private final char[] patternCharArray;
        private final int posMin;
        private final int posMax;

        PosPattern(String pattern, char[] patternCharArray, int posMin, int posMax) {
            super(pattern);
            this.patternCharArray = patternCharArray;
            this.posMin = posMin;
            this.posMax = posMax;
        }

        @Override
        public boolean matches(char[][] parts) {
            for (int i = this.posMin; i <= this.posMax; ++i) {
                if (!PatternIncludesArtifactFilter.match(this.patternCharArray, parts[i], i == 3)) continue;
                return true;
            }
            return false;
        }
    }

    static class OrPattern
    extends Pattern {
        private final Pattern[] patterns;

        OrPattern(String pattern, Pattern[] patterns) {
            super(pattern);
            this.patterns = patterns;
        }

        @Override
        public boolean matches(char[][] parts) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matches(parts)) continue;
                return true;
            }
            return false;
        }
    }

    static class AndPattern
    extends Pattern {
        private final Pattern[] patterns;

        AndPattern(String pattern, Pattern[] patterns) {
            super(pattern);
            this.patterns = patterns;
        }

        @Override
        public boolean matches(char[][] parts) {
            for (Pattern pattern : this.patterns) {
                if (pattern.matches(parts)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String translateEquals() {
            String[] strings = new String[this.patterns.length];
            for (int i = 0; i < this.patterns.length; ++i) {
                strings[i] = this.patterns[i].translateEquals(i);
                if (strings[i] != null) continue;
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < strings.length; ++i) {
                if (i > 0) {
                    sb.append(":");
                }
                sb.append(strings[i]);
            }
            return sb.toString();
        }
    }

    static abstract class Pattern {
        private final String pattern;

        Pattern(String pattern) {
            this.pattern = Objects.requireNonNull(pattern);
        }

        public abstract boolean matches(char[][] var1);

        public String translateEquals() {
            return null;
        }

        protected String translateEquals(int pos) {
            return null;
        }

        public String toString() {
            return this.pattern;
        }
    }
}

