/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import java.util.Optional;
import se.vandmo.dependencylock.maven.ArtifactIdentifier;

public final class Artifact
implements Comparable<Artifact> {
    public final ArtifactIdentifier identifier;
    public final String version;
    public final String scope;
    public final String type;

    public static Artifact from(org.apache.maven.artifact.Artifact artifact) {
        return new Artifact(new ArtifactIdentifier(artifact.getGroupId(), artifact.getArtifactId(), Optional.ofNullable(artifact.getClassifier())), artifact.getVersion(), artifact.getScope(), artifact.getType());
    }

    Artifact(ArtifactIdentifier identifier, String version, String scope, String type) {
        this.identifier = Objects.requireNonNull(identifier);
        this.version = Objects.requireNonNull(version);
        this.scope = Objects.requireNonNull(scope);
        this.type = Objects.requireNonNull(type);
    }

    @Override
    public int compareTo(Artifact other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier.toString()).append(':').append(this.version).append(':').append(this.scope).append(':').append(this.type);
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.identifier);
        hash = 17 * hash + Objects.hashCode(this.version);
        hash = 17 * hash + Objects.hashCode(this.scope);
        hash = 17 * hash + Objects.hashCode(this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Artifact other = (Artifact)obj;
        if (!Objects.equals(this.identifier, other.identifier)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.scope, other.scope)) {
            return false;
        }
        return Objects.equals(this.type, other.type);
    }
}

