/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import se.vandmo.dependencylock.maven.Artifacts;
import se.vandmo.dependencylock.maven.DependenciesLockFile;
import se.vandmo.dependencylock.maven.LockedDependencies;

@Mojo(name="lock", requiresDependencyResolution=ResolutionScope.TEST)
public final class LockMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="dependencies-lock.json")
    private String filename;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DependenciesLockFile lockFile = DependenciesLockFile.fromBasedir(this.basedir, this.filename);
        LockedDependencies existingLockedDependencies = this.getExistingLockedDependencies(lockFile);
        LockedDependencies lockedDependencies = existingLockedDependencies.updateWith(Artifacts.from(this.project.getArtifacts()));
        lockFile.write(lockedDependencies);
    }

    private LockedDependencies getExistingLockedDependencies(DependenciesLockFile lockFile) {
        if (lockFile.exists()) {
            return lockFile.read();
        }
        return LockedDependencies.empty();
    }
}

