/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.coding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.eclipse.packager.rpm.coding.PayloadCodingProvider;
import org.eclipse.packager.rpm.deps.Dependency;
import org.eclipse.packager.rpm.deps.RpmDependencyFlags;

public class BZip2PayloadCoding
implements PayloadCodingProvider {
    protected BZip2PayloadCoding() {
    }

    @Override
    public String getCoding() {
        return "bzip2";
    }

    @Override
    public void fillRequirements(Consumer<Dependency> requirementsConsumer) {
        requirementsConsumer.accept(new Dependency("PayloadIsBzip2", "3.0.5-1", RpmDependencyFlags.LESS, RpmDependencyFlags.EQUAL, RpmDependencyFlags.RPMLIB));
    }

    @Override
    public InputStream createInputStream(InputStream in) throws IOException {
        return new BZip2CompressorInputStream(in);
    }

    @Override
    public OutputStream createOutputStream(OutputStream out, Optional<String> optionalFlags) throws IOException {
        String flags;
        int blockSize = optionalFlags.isPresent() && (flags = optionalFlags.get()).length() > 0 ? Integer.parseInt(flags.substring(0, 1)) : 9;
        return new BZip2CompressorOutputStream(out, blockSize);
    }
}

