/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.cvss;

import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.ossindex.service.api.cvss.CvssMetric;
import org.sonatype.ossindex.service.api.cvss.CvssVector;

public class Cvss2Vector
extends CvssVector {
    public static final String VERSION = "2.0";
    public static final String ACCESS_VECTOR = "AV";
    public static final String ACCESS_COMPLEXITY = "AC";
    public static final String AUTHENTICATION = "Au";
    public static final String CONFIDENTIALITY_IMPACT = "C";
    public static final String INTEGRITY_IMPACT = "I";
    public static final String AVAILABILITY_IMPACT = "A";
    public static final String EXPLOITABILITY = "E";
    public static final String REMEDIATION_LEVEL = "RL";
    public static final String REPORT_CONFIDENCE = "RC";
    public static final String COLLATERAL_DAMAGE_POTENTIAL = "CDP";
    public static final String TARGET_DISTRIBUTION = "TD";
    public static final String CONFIDENTIALITY_REQUIREMENT = "CR";
    public static final String INTEGRITY_REQUIREMENT = "IR";
    public static final String AVAILABILITY_REQUIREMENT = "AR";
    private static final CvssMetric[] METRICS = new CvssMetric[]{CvssMetric.builder().code("AV").group("Base").title("Access Vector").meaning("N", "Network").meaning("A", "Adjacent Network").meaning("L", "Local").meaning("P", "Physical").build(), CvssMetric.builder().code("AC").group("Base").title("Access Complexity").meaning("L", "Low").meaning("M", "Medium").meaning("H", "High").build(), CvssMetric.builder().code("Au").group("Base").title("Authentication").meaning("N", "None").meaning("M", "Multiple").meaning("S", "Single").build(), CvssMetric.builder().code("C").group("Base").title("Confidentiality Impact").meaning("P", "Partial").meaning("C", "Complete").meaning("N", "None").build(), CvssMetric.builder().code("I").group("Base").title("Integrity Impact").meaning("P", "Partial").meaning("C", "Complete").meaning("N", "None").build(), CvssMetric.builder().code("A").group("Base").title("Availability Impact").meaning("P", "Partial").meaning("C", "Complete").meaning("N", "None").build(), CvssMetric.builder().code("E").group("Temporal").title("Exploitability").meaning("ND", "Not defined").meaning("H", "High").meaning("F", "Functional").meaning("POC", "Proof-of-concept").meaning("U", "Unproven").build(), CvssMetric.builder().code("RL").group("Temporal").title("Remediation Level").meaning("ND", "Not defined").meaning("U", "Unavailable").meaning("W", "Workaround").meaning("T", "Temporary fix").meaning("OF", "Official fix").build(), CvssMetric.builder().code("RC").group("Temporal").title("Report Confidence").meaning("ND", "Not defined").meaning("UC", "Unconfirmed").meaning("C", "Confirmed").meaning("UR", "Uncorroborated").build(), CvssMetric.builder().code("CDP").group("Environmental").title("Collateral Damage Potential").meaning("N", "None").meaning("L", "Low").meaning("LM", "Low-Medium").meaning("MH", "Medium-High").meaning("H", "High").meaning("ND", "Not defined").build(), CvssMetric.builder().code("TD").group("Environmental").title("Target Distribution").meaning("N", "None").meaning("L", "Low").meaning("M", "Medium").meaning("H", "High").meaning("ND", "Not defined").build(), CvssMetric.builder().code("CR").group("Environmental").title("Confidentiality Requirement").meaning("L", "Low").meaning("M", "Medium").meaning("H", "High").meaning("ND", "Not defined").build(), CvssMetric.builder().code("IR").group("Environmental").title("Integrity Requirement").meaning("L", "Low").meaning("M", "Medium").meaning("H", "High").meaning("ND", "Not defined").build(), CvssMetric.builder().code("AR").group("Environmental").title("Availability Requirement").meaning("L", "Low").meaning("M", "Medium").meaning("H", "High").meaning("ND", "Not defined").build()};
    private static final Map<String, CvssMetric> metrics = Cvss2Vector.createLookup(METRICS);

    public Cvss2Vector(String value) {
        super(VERSION, value);
    }

    @Override
    @Nullable
    protected CvssMetric findMetric(String code) {
        return metrics.get(code);
    }
}

