/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonatype.goodies.packageurl.MoreStrings;
import org.sonatype.goodies.packageurl.PackageUrlBuilder;
import org.sonatype.goodies.packageurl.PackageUrlParser;
import org.sonatype.goodies.packageurl.PercentEncoding;
import org.sonatype.goodies.packageurl.RenderFlavor;

@Immutable
public class PackageUrl
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEME = "pkg";
    private final String type;
    @Nullable
    private final List<String> namespace;
    private final String name;
    @Nullable
    private final String version;
    @Nullable
    private final Map<String, String> qualifiers;
    @Nullable
    private final List<String> subpath;

    @VisibleForTesting
    PackageUrl(String type, @Nullable List<String> namespace, String name, @Nullable String version, @Nullable Map<String, String> qualifiers, @Nullable List<String> subpath) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.namespace = namespace != null ? ImmutableList.copyOf(namespace) : null;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.version = version;
        this.qualifiers = qualifiers != null ? ImmutableMap.copyOf(qualifiers) : null;
        this.subpath = subpath != null ? ImmutableList.copyOf(subpath) : null;
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public List<String> getNamespace() {
        return this.namespace;
    }

    @Nullable
    public String getNamespaceAsString() {
        if (this.namespace != null && !this.namespace.isEmpty()) {
            return PackageUrl.renderSegments(new StringBuilder(), this.namespace, false).toString();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public Map<String, String> getQualifiers() {
        return this.qualifiers;
    }

    @Nullable
    public List<String> getSubpath() {
        return this.subpath;
    }

    @Nullable
    public String getSubpathAsString() {
        if (this.subpath != null && !this.subpath.isEmpty()) {
            return PackageUrl.renderSegments(new StringBuilder(), this.subpath, false).toString();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageUrl that = (PackageUrl)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals(this.qualifiers, that.qualifiers) && Objects.equals(this.subpath, that.subpath);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.namespace, this.name, this.version, this.qualifiers, this.subpath);
    }

    @VisibleForTesting
    String explain() {
        return "{type='" + this.type + '\'' + ", namespace=" + this.namespace + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", qualifiers=" + this.qualifiers + ", subpath=" + this.subpath + '}';
    }

    public PackageUrlBuilder asBuilder() {
        return new PackageUrlBuilder().from(this);
    }

    public URI toUri() {
        return URI.create(this.toString());
    }

    public String toString() {
        return this.toString(RenderFlavor.getDefault());
    }

    public String toString(RenderFlavor flavor) {
        Preconditions.checkNotNull((Object)((Object)flavor));
        StringBuilder buff = new StringBuilder();
        if (flavor == RenderFlavor.SCHEME) {
            buff.append(SCHEME).append(':');
        }
        buff.append(MoreStrings.lowerCase(this.type));
        if (flavor == RenderFlavor.SCHEME) {
            buff.append('/');
        } else {
            buff.append(':');
        }
        if (this.namespace != null && !this.namespace.isEmpty()) {
            PackageUrl.renderSegments(buff, this.namespace, true);
            buff.append('/');
        }
        buff.append(PercentEncoding.encodeName(this.name));
        if (this.version != null) {
            buff.append('@').append(PercentEncoding.encodeVersion(this.version));
        }
        if (this.qualifiers != null && !this.qualifiers.isEmpty()) {
            buff.append('?');
            TreeSet<Map.Entry<String, String>> sorted = new TreeSet<Map.Entry<String, String>>(new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> entry1, Map.Entry<String, String> entry2) {
                    return ComparisonChain.start().compare((Comparable)((Object)entry1.getKey()), (Comparable)((Object)entry2.getKey())).compare((Comparable)((Object)entry1.getValue()), (Comparable)((Object)entry2.getValue())).result();
                }
            });
            sorted.addAll(this.qualifiers.entrySet());
            Iterator iter = sorted.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                buff.append((String)entry.getKey()).append('=').append(PercentEncoding.encodeQualifierValue((String)entry.getValue()));
                if (!iter.hasNext()) continue;
                buff.append('&');
            }
        }
        if (this.subpath != null && !this.subpath.isEmpty()) {
            buff.append('#');
            PackageUrl.renderSegments(buff, this.subpath, true);
        }
        return buff.toString();
    }

    private static StringBuilder renderSegments(StringBuilder buff, List<String> segments, boolean encode) {
        Iterator<String> iter = segments.iterator();
        while (iter.hasNext()) {
            String segment = iter.next();
            if (encode) {
                segment = PercentEncoding.encodeSegment(segment);
            }
            buff.append(segment);
            if (!iter.hasNext()) continue;
            buff.append('/');
        }
        return buff;
    }

    public static PackageUrl parse(String value) {
        return PackageUrlParser.parse(value);
    }

    public static PackageUrlBuilder builder() {
        return new PackageUrlBuilder();
    }
}

