/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.net.URI;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.MethodExistsCallQuery;
import org.anarres.jdiagnostics.Result;

public class ProxyQuery
extends AbstractQuery {
    private final URI uri;

    public ProxyQuery(URI uri) {
        this.uri = uri;
    }

    public String getName() {
        return "proxy/" + this.uri;
    }

    public void call(Result result, String prefix) {
        Class<?> proxySelectorType = new ClassExistsQuery("java.net.ProxySelector").findClass(result, prefix);
        if (proxySelectorType == null) {
            return;
        }
        Object proxySelector = new MethodExistsCallQuery(null, proxySelectorType, "getDefault").invoke(result, prefix + "factory/");
        if (proxySelector == null) {
            return;
        }
        new MethodExistsCallQuery(proxySelector, proxySelectorType, "select", new Class[]{URI.class}, new Object[]{this.uri}).call(result, prefix + this.uri.getScheme() + "/");
    }
}

