/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassFieldExistsGetQuery;
import org.anarres.jdiagnostics.JarQuery;
import org.anarres.jdiagnostics.Result;

public class XercesQuery
extends AbstractQuery {
    private static final String XERCES_JARNAME = "xerces.jar";
    private static final String XERCESIMPL_JARNAME = "xercesImpl.jar";
    private static final String PARSERAPIS_JARNAME = "xmlParserAPIs.jar";
    private static final String XERCES1_VERSION_CLASS = "org.apache.xerces.framework.Version";
    private static final String XERCES1_VERSION_FIELD = "fVersion";
    private static final String XERCES2_VERSION_CLASS = "org.apache.xerces.impl.Version";
    private static final String XERCES2_VERSION_FIELD = "fVersion";

    public String getName() {
        return "xerces";
    }

    public void call(Result result, String prefix) {
        new JarQuery(XERCES_JARNAME).call(result, prefix + "/xercesJar");
        new JarQuery(XERCESIMPL_JARNAME).call(result, prefix + "/xercesImplJar");
        new JarQuery(PARSERAPIS_JARNAME).call(result, prefix + "/parserApisJar");
        for (String packagePrefix : new String[]{"org.apache.xerces.", "com.sun.org.apache.xerces.internal."}) {
            new ClassFieldExistsGetQuery(null, packagePrefix + "framework.Version", "fVersion", new String[0]).call(result, prefix + packagePrefix + "xerces1/");
            new ClassFieldExistsGetQuery(null, packagePrefix + "impl.Version", "fVersion", new String[0]).call(result, prefix + packagePrefix + "xerces2/");
        }
    }
}

