/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.response.ErrorResponse;

public abstract class Command
implements CVSListener,
Cloneable {
    protected String localDirectory;
    private GlobalOptions globalOptions;
    private boolean failed = false;
    private String displayName;

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, CommandAbortedException, AuthenticationException {
        this.setLocalDirectory(clientServices.getLocalPath());
        this.globalOptions = clientServices.getGlobalOptions();
    }

    public abstract String getCVSCommand();

    public abstract String getCVSArguments();

    public abstract boolean setCVSCommand(char var1, String var2);

    public abstract void resetCVSCommand();

    public abstract String getOptString();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public void messageSent(MessageEvent messageEvent) {
        if (messageEvent.isError() && messageEvent.getSource() instanceof ErrorResponse || messageEvent.getSource() == this) {
            this.failed = true;
        }
    }

    public void messageSent(BinaryMessageEvent binaryMessageEvent) {
    }

    public void fileAdded(FileAddedEvent fileAddedEvent) {
    }

    public void fileToRemove(FileToRemoveEvent fileToRemoveEvent) {
    }

    public void fileRemoved(FileRemovedEvent fileRemovedEvent) {
    }

    public void fileUpdated(FileUpdatedEvent fileUpdatedEvent) {
    }

    public void fileInfoGenerated(FileInfoEvent fileInfoEvent) {
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
    }

    public void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
    }

    public final String getLocalDirectory() {
        return this.localDirectory;
    }

    public final String getLocalPath() {
        return this.localDirectory;
    }

    public final GlobalOptions getGlobalOptions() {
        return this.globalOptions;
    }

    public final String getRelativeToLocalPathInUnixStyle(File file) {
        String string = file.getAbsolutePath();
        int n = this.localDirectory.length() + 1;
        if (n >= string.length()) {
            return ".";
        }
        String string2 = string.substring(n);
        return string2.replace('\\', '/');
    }

    protected final void setLocalDirectory(String string) {
        this.localDirectory = string;
    }

    protected static final String getTrimmedString(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

