/*
 * Decompiled with CFR 0.152.
 */
package name.dmaus.schxslt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import name.dmaus.schxslt.Resolver;
import name.dmaus.schxslt.SchematronException;
import net.jcip.annotations.ThreadSafe;
import org.w3c.dom.Document;

@ThreadSafe
public final class Compiler {
    private static final String[] XSLT10STEPS = new String[]{"/xslt/1.0/include.xsl", "/xslt/1.0/expand.xsl", "/xslt/1.0/compile-for-svrl.xsl"};
    private static final String[] XSLT20STEPS = new String[]{"/xslt/2.0/include.xsl", "/xslt/2.0/expand.xsl", "/xslt/2.0/compile-for-svrl.xsl"};
    private static final String QUERYBINDING_XSLT1 = "xslt";
    private static final String QUERYBINDING_XSLT2 = "xslt2";
    private static final String QUERYBINDING_XSLT3 = "xslt3";
    private static final String QUERYBINDING_DEFAULT = "";
    private final TransformerFactory transformerFactory;

    public Compiler() {
        this.transformerFactory = TransformerFactory.newInstance();
        this.transformerFactory.setURIResolver(new Resolver());
    }

    public Compiler(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Document compile(Source schema, Map<String, Object> options) throws SchematronException {
        Document schematron = this.loadSchematron(schema);
        try {
            List<Transformer> pipeline;
            String queryBinding;
            switch (queryBinding = schematron.getDocumentElement().getAttribute("queryBinding").toLowerCase()) {
                case "": 
                case "xslt": {
                    pipeline = this.createPipeline(XSLT10STEPS, options);
                    break;
                }
                case "xslt2": 
                case "xslt3": {
                    pipeline = this.createPipeline(XSLT20STEPS, options);
                    break;
                }
                default: {
                    throw new SchematronException("Unsupported query language: " + queryBinding);
                }
            }
            String systemId = schematron.getDocumentURI();
            DOMSource schemaSource = new DOMSource(schematron, systemId);
            Document stylesheet = this.applyPipeline(pipeline, schemaSource);
            stylesheet.setDocumentURI(systemId);
            return stylesheet;
        }
        catch (TransformerException e) {
            throw new SchematronException("Error compiling Schematron to transformation stylesheet", e);
        }
    }

    private Document loadSchematron(Source source) throws SchematronException {
        String systemId = source.getSystemId();
        try {
            Transformer identityTransformer = this.transformerFactory.newTransformer();
            DOMResult schema = new DOMResult();
            identityTransformer.transform(source, schema);
            Document schemaDocument = (Document)schema.getNode();
            schemaDocument.setDocumentURI(systemId);
            return schemaDocument;
        }
        catch (TransformerException e) {
            throw new SchematronException("Error creating the Schematron document", e);
        }
    }

    private List<Transformer> createPipeline(String[] steps, Map<String, Object> options) throws TransformerException {
        Resolver resolver = new Resolver();
        ArrayList<Transformer> templates = new ArrayList<Transformer>();
        for (String step : steps) {
            Source source = resolver.resolve(step, null);
            Transformer transformer = this.transformerFactory.newTransformer(source);
            if (options != null) {
                for (Map.Entry<String, Object> param : options.entrySet()) {
                    transformer.setParameter(param.getKey(), param.getValue());
                }
            }
            templates.add(transformer);
        }
        return templates;
    }

    private Document applyPipeline(List<Transformer> steps, Source document) throws TransformerException {
        DOMResult result = null;
        Source source = document;
        for (Transformer transformer : steps) {
            result = new DOMResult();
            transformer.transform(source, result);
            source = new DOMSource(result.getNode(), source.getSystemId());
        }
        return (Document)result.getNode();
    }
}

