/*
 * Decompiled with CFR 0.152.
 */
package name.dmaus.schxslt;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import name.dmaus.schxslt.Compiler;
import name.dmaus.schxslt.Resolver;
import name.dmaus.schxslt.Result;
import name.dmaus.schxslt.SchematronException;
import name.dmaus.schxslt.Validator;
import net.jcip.annotations.ThreadSafe;
import org.w3c.dom.Document;

@ThreadSafe
public final class Schematron {
    private Validator validator;

    public Schematron(Source schematron) throws SchematronException {
        this(schematron, null, null);
    }

    public Schematron(Source schematron, String phase) throws SchematronException {
        this(schematron, phase, null);
    }

    public Schematron(Source schematron, String phase, TransformerFactory transformerFactory) throws SchematronException {
        this(schematron, phase, transformerFactory, null);
    }

    public Schematron(Source schematron, String phase, TransformerFactory transformerFactory, Map<String, Object> options) throws SchematronException {
        if (schematron == null) {
            throw new IllegalArgumentException("Source may not be null");
        }
        TransformerFactory factory = transformerFactory;
        if (factory == null) {
            factory = TransformerFactory.newInstance();
            factory.setURIResolver(new Resolver());
        }
        Document stylesheet = this.compile(factory, schematron, phase, options);
        try {
            Templates templates = factory.newTemplates(new DOMSource(stylesheet, stylesheet.getDocumentURI()));
            this.validator = new Validator(templates);
        }
        catch (TransformerException e) {
            throw new SchematronException("Unable to create Validator instance", e);
        }
    }

    public Result validate(Source document) throws SchematronException {
        return this.validate(document, null);
    }

    public Result validate(Source document, Map<String, Object> parameters) throws SchematronException {
        return this.validator.validate(document, parameters);
    }

    private Document compile(TransformerFactory transformerFactory, Source schema, String phase, Map<String, Object> options) throws SchematronException {
        Compiler compiler = new Compiler(transformerFactory);
        HashMap<String, Object> compilerOptions = new HashMap<String, Object>();
        if (options != null) {
            compilerOptions.putAll(options);
        }
        if (phase != null) {
            compilerOptions.put("phase", phase);
        }
        return compiler.compile(schema, compilerOptions);
    }
}

