/*
 * Decompiled with CFR 0.152.
 */
package name.dmaus.schxslt;

import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import name.dmaus.schxslt.Result;
import name.dmaus.schxslt.SchematronException;
import net.jcip.annotations.ThreadSafe;
import org.w3c.dom.Document;

@ThreadSafe
final class Validator {
    private final Templates schema;

    Validator(Templates schema) {
        this.schema = schema;
    }

    public Result validate(Source document, Map<String, Object> parameters) throws SchematronException {
        try {
            Transformer transformer = this.schema.newTransformer();
            if (parameters != null) {
                for (Map.Entry<String, Object> param : parameters.entrySet()) {
                    transformer.setParameter(param.getKey(), param.getValue());
                }
            }
            DOMResult result = new DOMResult();
            transformer.transform(document, result);
            return new Result((Document)result.getNode());
        }
        catch (TransformerException e) {
            throw new SchematronException("Error running transformation stylesheet", e);
        }
    }
}

