/*
 * Decompiled with CFR 0.152.
 */
package name.dmaus.schxslt;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import name.dmaus.schxslt.SchematronException;
import name.dmaus.schxslt.adapter.Adapter;
import net.jcip.annotations.ThreadSafe;
import org.w3c.dom.Document;
import org.xmlresolver.XMLResolver;

@ThreadSafe
public final class Compiler {
    private final Adapter adapter;
    private final TransformerFactory transformerFactory;
    private final XMLResolver xmlResolver = new XMLResolver();

    public Compiler(Adapter adapter) {
        this.adapter = adapter;
        this.transformerFactory = TransformerFactory.newInstance();
        this.transformerFactory.setURIResolver(this.xmlResolver.getURIResolver());
    }

    public Compiler(Adapter adapter, TransformerFactory transformerFactory) {
        this.adapter = adapter;
        this.transformerFactory = transformerFactory;
    }

    public Document compile(Source schema, Map<String, Object> options) throws SchematronException {
        Document schematron = this.loadSchematron(schema);
        try {
            String queryBinding = schematron.getDocumentElement().getAttribute("queryBinding").toLowerCase(Locale.ROOT);
            List<Transformer> pipeline = this.createPipeline(this.adapter.getTranspilerStylesheets(queryBinding), options);
            String systemId = schematron.getDocumentURI();
            DOMSource schemaSource = new DOMSource(schematron, systemId);
            Document stylesheet = this.applyPipeline(pipeline, schemaSource);
            stylesheet.setDocumentURI(systemId);
            return stylesheet;
        }
        catch (TransformerException e) {
            throw new SchematronException("Error compiling Schematron to transformation stylesheet", e);
        }
    }

    private Document loadSchematron(Source source) throws SchematronException {
        String systemId = source.getSystemId();
        try {
            Transformer identityTransformer = this.transformerFactory.newTransformer();
            DOMResult schema = new DOMResult();
            identityTransformer.transform(source, schema);
            Document schemaDocument = (Document)schema.getNode();
            schemaDocument.setDocumentURI(systemId);
            return schemaDocument;
        }
        catch (TransformerException e) {
            throw new SchematronException("Error creating the Schematron document", e);
        }
    }

    private List<Transformer> createPipeline(List<String> steps, Map<String, Object> options) throws TransformerException {
        URIResolver resolver = this.xmlResolver.getURIResolver();
        ArrayList<Transformer> templates = new ArrayList<Transformer>();
        for (String step : steps) {
            Source source = resolver.resolve(step, null);
            Transformer transformer = this.transformerFactory.newTransformer(source);
            if (options != null) {
                for (Map.Entry<String, Object> param : options.entrySet()) {
                    transformer.setParameter(param.getKey(), param.getValue());
                }
            }
            templates.add(transformer);
        }
        return templates;
    }

    private Document applyPipeline(List<Transformer> steps, Source document) throws TransformerException {
        DOMResult result = null;
        Source source = document;
        for (Transformer transformer : steps) {
            result = new DOMResult();
            transformer.transform(source, result);
            source = new DOMSource(result.getNode(), source.getSystemId());
        }
        return (Document)result.getNode();
    }
}

