/*
 * Decompiled with CFR 0.152.
 */
package name.dmaus.schxslt.testsuite.maven;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import name.dmaus.schxslt.testsuite.Driver;
import name.dmaus.schxslt.testsuite.Report;
import name.dmaus.schxslt.testsuite.Testsuite;
import name.dmaus.schxslt.testsuite.TestsuiteRunner;
import name.dmaus.schxslt.testsuite.ValidationFactory;
import name.dmaus.schxslt.testsuite.ValidationResult;
import name.dmaus.schxslt.testsuite.ValidationStatus;
import name.dmaus.schxslt.testsuite.maven.TestsuiteSpec;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.context.support.FileSystemXmlApplicationContext;

@Mojo(name="test-schematron")
public final class TestSchematronMojo
extends AbstractMojo {
    @Parameter(required=false, defaultValue="${basedir}")
    private String basedir;
    @Parameter(required=true)
    private File config;
    @Parameter(required=false)
    private List<TestsuiteSpec> testsuites;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)this.basedir);
        boolean failMojoExecution = false;
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(this.config.toURI().toString());
        for (TestsuiteSpec spec : this.testsuites) {
            Testsuite testsuite = spec.createTestsuite();
            this.getLog().info((CharSequence)("Running testsuite " + testsuite.getLabel()));
            ValidationFactory factory = (ValidationFactory)ctx.getBean(spec.getProcessorId());
            factory.setBaseDirectory(Paths.get(this.basedir, new String[0]));
            Driver driver = new Driver(factory);
            TestsuiteRunner runner = spec.getSkip() == null ? new TestsuiteRunner(driver) : new TestsuiteRunner(driver, spec.getSkip());
            Report report = runner.run(testsuite);
            this.printReport(report);
            String msg = String.format("[Passed/Skipped/Failed/Total] = [%d/%d/%d/%d]", report.countSuccess(), report.countSkipped(), report.countFailure() + report.countError(), report.countTotal());
            if (report.countFailure() > 0 || report.countError() > 0) {
                failMojoExecution = true;
                this.getLog().error((CharSequence)msg);
                continue;
            }
            this.getLog().info((CharSequence)msg);
        }
        if (failMojoExecution) {
            throw new MojoFailureException("Some Schematron tests failed");
        }
    }

    void printReport(Report report) {
        for (ValidationResult result : report.getValidationResults()) {
            String msg = String.format("Status: %s Id: %s Label: %s", result.getStatus(), result.getTestcase().getId(), result.getTestcase().getLabel());
            if (result.getStatus() == ValidationStatus.FAILURE || result.getStatus() == ValidationStatus.ERROR) {
                this.getLog().error((CharSequence)msg);
                if (result.getErrorMessage() != null) {
                    this.getLog().error((CharSequence)result.getErrorMessage());
                }
            } else if (result.getStatus() == ValidationStatus.SKIPPED) {
                this.getLog().warn((CharSequence)msg);
            }
            result.getTestcase().deleteTemporaryFiles();
        }
    }
}

