/*
 * Decompiled with CFR 0.152.
 */
package name.jervyshi.nacos;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import name.jervyshi.nacos.NacosPorts;
import name.jervyshi.nacos.NacosProcess;
import name.jervyshi.nacos.exception.NacosEmbeddedException;
import name.jervyshi.nacos.infra.NacosBinaryDownloader;
import name.jervyshi.nacos.infra.NacosWaiter;
import name.jervyshi.nacos.infra.OsResolver;
import name.jervyshi.nacos.infra.ZipUtil;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosStarter {
    private static final Logger logger = LoggerFactory.getLogger(NacosStarter.class);
    private String nacosVersion;
    private Path downloadPath;
    private Path nacosHomePath;
    private AtomicBoolean started;
    private NacosProcess nacosProcess;
    private String host;
    private NacosPorts nacosPorts;
    private String nacosTokenSecretKey;

    NacosStarter(String nacosVersion, Path downloadPath, String host, NacosPorts nacosPorts, String nacosTokenSecretKey) {
        this.nacosVersion = nacosVersion;
        this.downloadPath = downloadPath;
        this.host = host;
        this.nacosPorts = nacosPorts;
        this.nacosTokenSecretKey = nacosTokenSecretKey;
        this.started = new AtomicBoolean(false);
    }

    public NacosProcess start() {
        Process innerProcess = null;
        try {
            logger.info("Start new nacos process.");
            this.checkInitialState();
            if (this.started.compareAndSet(false, true)) {
                this.nacosHomePath = Paths.get(this.downloadPath.toAbsolutePath().toString(), String.valueOf(this.nacosPorts.getServerPort()), "nacos");
                if (!this.isBinaryDownloaded()) {
                    this.downloadAndUnpackBinary();
                }
                int serverPort = this.nacosPorts.getServerPort();
                ArrayList<String> command = new ArrayList<String>();
                if (this.isWindows()) {
                    command.add(Paths.get(System.getenv("JAVA_HOME"), "bin", "java.exe").toAbsolutePath().toString());
                } else {
                    command.add(Paths.get(System.getenv("JAVA_HOME"), "bin", "java").toAbsolutePath().toString());
                }
                command.add("-Dnacos.standalone=true");
                command.add("-Dnacos.core.auth.plugin.nacos.token.secret.key=" + this.nacosTokenSecretKey);
                command.add("-Dnacos.home=" + this.nacosHomePath.toAbsolutePath().toString());
                command.add("-Dserver.port=" + serverPort);
                command.add("-jar");
                command.add(this.getAbsolutePath("target", "nacos-server.jar"));
                command.add("--spring.config.location=classpath:/,optional:classpath:/config/,optional:file:./,optional:file:./config/,optional:file:" + this.getAbsolutePath("conf") + File.separator);
                command.add("--logging.config=" + this.getAbsolutePath("conf", "nacos-logback.xml"));
                innerProcess = new ProcessBuilder(new String[0]).directory(this.nacosHomePath.toFile()).command(command).inheritIO().redirectOutput(ProcessBuilder.Redirect.PIPE).start();
                this.nacosProcess = new NacosProcess(this.host, this.nacosPorts, innerProcess);
                logger.info("Starting nacos server on port: {}", (Object)serverPort);
                new NacosWaiter(this.host, serverPort).avoidUntilNacosServerStarted();
                logger.info("Nacos server started");
            }
        }
        catch (NacosEmbeddedException e) {
            try {
                List outputLines = IOUtils.readLines((InputStream)innerProcess.getInputStream(), (String)"UTF-8");
                outputLines.forEach(System.err::println);
                List errorLines = IOUtils.readLines((InputStream)innerProcess.getErrorStream(), (String)"UTF-8");
                errorLines.forEach(System.err::println);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (IOException e) {
            logger.error("fail to start nacos process, nacosVersion: {}, downloadPath:{}", new Object[]{this.nacosVersion, this.downloadPath, e});
            throw new NacosEmbeddedException("fail to start nacos process");
        }
        return this.nacosProcess;
    }

    private void downloadAndUnpackBinary() throws IOException {
        Path filePath = this.getDownloadFilePath();
        if (!Files.exists(filePath, new LinkOption[0])) {
            logger.info("Download nacos archive to {}", (Object)filePath);
            NacosBinaryDownloader.getNacosBinaryArchive(this.nacosVersion, filePath);
        }
        String unzipLocation = Paths.get(this.downloadPath.toAbsolutePath().toString(), String.valueOf(this.nacosPorts.getServerPort())).toAbsolutePath().toString();
        logger.info("Unzip nacos archive files into: {}", (Object)unzipLocation);
        ZipUtil.unzip(filePath.toAbsolutePath().toString(), unzipLocation);
    }

    private boolean isWindows() {
        return OsResolver.resolve().contains("windows");
    }

    private boolean isBinaryDownloaded() {
        return this.getNacosServerJar().exists();
    }

    private Path getDownloadFilePath() {
        return Paths.get(this.downloadPath.toAbsolutePath().toString(), String.format("nacos-server-%s.zip", this.nacosVersion));
    }

    private File getNacosServerJar() {
        Path path = Paths.get(this.nacosHomePath.toAbsolutePath().toString(), "target", "nacos-server.jar");
        return path.toFile();
    }

    private void checkInitialState() {
        if (this.started.get()) {
            throw new NacosEmbeddedException("This Nacos Starter already started nacos server. Create new Nacos Server Instance");
        }
    }

    private String getAbsolutePath(String ... item) {
        return Paths.get(this.nacosHomePath.toAbsolutePath().toString(), item).toString();
    }
}

