/*
 * Decompiled with CFR 0.152.
 */
package name.jervyshi.nacos.infra;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import name.jervyshi.nacos.exception.NacosEmbeddedException;

public class ZipUtil {
    public static void unzip(String zipFilePath, String unzipLocation) {
        try {
            if (!Files.exists(Paths.get(unzipLocation, new String[0]), new LinkOption[0])) {
                Files.createDirectories(Paths.get(unzipLocation, new String[0]), new FileAttribute[0]);
            }
            try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilePath));){
                ZipEntry entry = zipInputStream.getNextEntry();
                while (entry != null) {
                    Path filePath = Paths.get(unzipLocation, entry.getName());
                    if (!entry.isDirectory()) {
                        ZipUtil.unzipFiles(zipInputStream, filePath);
                    } else {
                        Files.createDirectories(filePath, new FileAttribute[0]);
                    }
                    zipInputStream.closeEntry();
                    entry = zipInputStream.getNextEntry();
                }
            }
        }
        catch (IOException e) {
            throw new NacosEmbeddedException("unzip files error", e);
        }
    }

    public static void unzipFiles(ZipInputStream zipInputStream, Path unzipFilePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(unzipFilePath.toFile()));){
            int read;
            byte[] bytesIn = new byte[1024];
            while ((read = zipInputStream.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }
}

