/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.reader;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import name.nkonev.r2dbc.migrate.reader.MigrateResource;
import name.nkonev.r2dbc.migrate.reader.MigrateResourceReader;
import name.nkonev.r2dbc.migrate.reader.SpringResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class SpringResourceReader
implements MigrateResourceReader {
    private final ResourcePatternResolver resolver;

    public SpringResourceReader() {
        this.resolver = new PathMatchingResourcePatternResolver();
    }

    public SpringResourceReader(ResourcePatternResolver resourcePatternResolver) {
        this.resolver = resourcePatternResolver;
    }

    public List<MigrateResource> getResources(String resourcesPath) {
        try {
            Resource[] resources = this.resolver.getResources(resourcesPath);
            return Arrays.stream(resources).map(SpringResource::new).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

