/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.fastzipfilereader.NestedJarHandler;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.fileslice.ArraySlice;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.fileslice.FileSlice;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.fileslice.Slice;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.FastPathResolver;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.FileUtils;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;

@RelocatedClass
@Generated
@SuppressFBWarnings
class PhysicalZipFile {
    private final File file;
    private final String path;
    Slice slice;
    NestedJarHandler nestedJarHandler;
    private int hashCode;

    PhysicalZipFile(File file2, NestedJarHandler nestedJarHandler, LogNode log) throws IOException {
        FileUtils.checkCanReadAndIsFile(file2);
        this.file = file2;
        this.nestedJarHandler = nestedJarHandler;
        this.path = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, file2.getPath());
        this.slice = new FileSlice(file2, nestedJarHandler, log);
    }

    PhysicalZipFile(byte[] arr, File outermostFile, String path, NestedJarHandler nestedJarHandler) throws IOException {
        this.file = outermostFile;
        this.path = path;
        this.nestedJarHandler = nestedJarHandler;
        this.slice = new ArraySlice(arr, false, 0L, nestedJarHandler);
    }

    PhysicalZipFile(InputStream inputStream, long inputStreamLengthHint, String path, NestedJarHandler nestedJarHandler, LogNode log) throws IOException {
        this.nestedJarHandler = nestedJarHandler;
        this.path = path;
        this.slice = nestedJarHandler.readAllBytesWithSpilloverToDisk(inputStream, path, inputStreamLengthHint, log);
        this.file = this.slice instanceof FileSlice ? ((FileSlice)this.slice).file : null;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public long length() {
        return this.slice.sliceLength;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = this.hashCode = this.file == null ? 0 : this.file.hashCode();
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhysicalZipFile)) {
            return false;
        }
        PhysicalZipFile other = (PhysicalZipFile)o;
        return Objects.equals(this.file, other.file);
    }

    public String toString() {
        return this.path;
    }
}

