/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.io.github.classgraph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.io.github.classgraph.Resource;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.io.github.classgraph.Scanner;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.concurrency.WorkQueue;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.scanspec.ScanSpec;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.FileUtils;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.JarUtils;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;

@RelocatedClass
@Generated
@SuppressFBWarnings
abstract class ClasspathElement {
    int classpathElementIdx;
    List<String> nestedClasspathRootPrefixes;
    boolean skipClasspathElement;
    boolean containsSpecificallyWhitelistedClasspathElementResourcePath;
    final Queue<Map.Entry<Integer, ClasspathElement>> childClasspathElementsIndexed = new ConcurrentLinkedQueue<Map.Entry<Integer, ClasspathElement>>();
    List<ClasspathElement> childClasspathElementsOrdered;
    protected final List<Resource> whitelistedResources = new ArrayList<Resource>();
    protected List<Resource> whitelistedClassfileResources = new ArrayList<Resource>();
    protected final Map<File, Long> fileToLastModified = new ConcurrentHashMap<File, Long>();
    protected final AtomicBoolean scanned = new AtomicBoolean(false);
    protected ClassLoader classLoader;
    String moduleNameFromModuleDescriptor;
    final ScanSpec scanSpec;

    ClasspathElement(ClassLoader classLoader, ScanSpec scanSpec) {
        this.classLoader = classLoader;
        this.scanSpec = scanSpec;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    int getNumClassfileMatches() {
        return this.whitelistedClassfileResources == null ? 0 : this.whitelistedClassfileResources.size();
    }

    protected void checkResourcePathWhiteBlackList(String relativePath2, LogNode log) {
        if (!this.scanSpec.classpathElementResourcePathWhiteBlackList.whitelistAndBlacklistAreEmpty()) {
            if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isBlacklisted(relativePath2)) {
                if (log != null) {
                    log.log("Reached blacklisted classpath element resource path, stopping scanning: " + relativePath2);
                }
                this.skipClasspathElement = true;
                return;
            }
            if (this.scanSpec.classpathElementResourcePathWhiteBlackList.isSpecificallyWhitelisted(relativePath2)) {
                if (log != null) {
                    log.log("Reached specifically whitelisted classpath element resource path: " + relativePath2);
                }
                this.containsSpecificallyWhitelistedClasspathElementResourcePath = true;
            }
        }
    }

    void maskClassfiles(int classpathIdx, Set<String> classpathRelativePathsFound, LogNode log) {
        ArrayList<Resource> whitelistedClassfileResourcesFiltered = new ArrayList<Resource>(this.whitelistedClassfileResources.size());
        boolean foundMasked = false;
        for (Resource res : this.whitelistedClassfileResources) {
            String pathRelativeToPackageRoot = res.getPath();
            if (!(pathRelativeToPackageRoot.equals("module-info.class") || pathRelativeToPackageRoot.equals("package-info.class") || pathRelativeToPackageRoot.endsWith("/package-info.class") || classpathRelativePathsFound.add(pathRelativeToPackageRoot))) {
                foundMasked = true;
                if (log == null) continue;
                log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + JarUtils.classfilePathToClassName(pathRelativeToPackageRoot) + " found at " + res);
                continue;
            }
            whitelistedClassfileResourcesFiltered.add(res);
        }
        if (foundMasked) {
            this.whitelistedClassfileResources = whitelistedClassfileResourcesFiltered;
        }
    }

    protected void addWhitelistedResource(Resource resource, ScanSpec.ScanSpecPathMatch parentMatchStatus, boolean isClassfileOnly, LogNode log) {
        String path = resource.getPath();
        boolean isClassFile = FileUtils.isClassfile(path);
        boolean isWhitelisted = false;
        if (isClassFile) {
            if (this.scanSpec.enableClassInfo && !this.scanSpec.classfilePathWhiteBlackList.isBlacklisted(path)) {
                this.whitelistedClassfileResources.add(resource);
                isWhitelisted = true;
            }
        } else {
            isWhitelisted = true;
        }
        if (!isClassfileOnly) {
            this.whitelistedResources.add(resource);
        }
        if (log != null && isWhitelisted) {
            String logStr;
            String type = isClassFile ? "classfile" : "resource";
            switch (parentMatchStatus) {
                case HAS_WHITELISTED_PATH_PREFIX: {
                    logStr = "Found " + type + " within subpackage of whitelisted package: ";
                    break;
                }
                case AT_WHITELISTED_PATH: {
                    logStr = "Found " + type + " within whitelisted package: ";
                    break;
                }
                case AT_WHITELISTED_CLASS_PACKAGE: {
                    logStr = "Found specifically-whitelisted " + type + ": ";
                    break;
                }
                default: {
                    logStr = "Found whitelisted " + type + ": ";
                }
            }
            resource.scanLog = log.log("0:" + path, logStr + path + (path.equals(resource.getPathRelativeToClasspathElement()) ? "" : " ; full path: " + resource.getPathRelativeToClasspathElement()));
        }
    }

    protected void finishScanPaths(LogNode log) {
        if (log != null) {
            if (this.whitelistedResources.isEmpty() && this.whitelistedClassfileResources.isEmpty()) {
                log.log(this.scanSpec.enableClassInfo ? "No whitelisted classfiles or resources found" : "Classfile scanning is disabled, and no whitelisted resources found");
            } else if (this.whitelistedResources.isEmpty()) {
                log.log("No whitelisted resources found");
            } else if (this.whitelistedClassfileResources.isEmpty()) {
                log.log(this.scanSpec.enableClassInfo ? "No whitelisted classfiles found" : "Classfile scanning is disabled");
            }
        }
        if (log != null) {
            log.addElapsedTime();
        }
    }

    protected LogNode log(int classpathElementIdx, String msg, LogNode log) {
        return log.log(String.format("%07d", classpathElementIdx), msg);
    }

    abstract void open(WorkQueue<Scanner.ClasspathEntryWorkUnit> var1, LogNode var2) throws InterruptedException;

    abstract void scanPaths(LogNode var1);

    abstract Resource getResource(String var1);

    abstract URI getURI();

    abstract File getFile();

    abstract String getModuleName();
}

