/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Config;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.HTMLElementNameSet;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.HTMLElementTerminatingTagNameSets;

@RelocatedClass
@Generated
@SuppressFBWarnings
public final class HTMLElements {
    private static final List<String> ALL = new ArrayList<String>(Arrays.asList("a", "abbr", "acronym", "address", "applet", "area", "article", "aside", "audio", "b", "base", "basefont", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "command", "datalist", "dd", "del", "details", "dfn", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "iframe", "img", "input", "ins", "isindex", "kbd", "keygen", "label", "legend", "li", "link", "map", "mark", "menu", "meta", "meter", "nav", "noframes", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "small", "source", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "tt", "u", "ul", "var", "video", "wbr"));
    private static final HTMLElementNameSet BLOCK = new HTMLElementNameSet("article", "aside", "footer", "details", "section", "header", "hgroup", "nav", "p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address");
    private static final HTMLElementNameSet INLINE = new HTMLElementNameSet("bdi", "keygen", "mark", "meter", "output", "progress", "rp", "rt", "ruby", "time", "wbr", "tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button", "ins", "del");
    private static final HTMLElementNameSet END_TAG_FORBIDDEN_SET = new HTMLElementNameSet("area", "base", "basefont", "br", "col", "command", "embed", "frame", "hr", "img", "input", "isindex", "keygen", "link", "meta", "param", "source", "wbr");
    private static final HTMLElementNameSet _UL_OL = new HTMLElementNameSet("ul").union("ol");
    private static final HTMLElementNameSet _DD_DT = new HTMLElementNameSet("dd").union("dt");
    private static final HTMLElementNameSet _THEAD_TBODY_TFOOT_TR = new HTMLElementNameSet("thead").union("tbody").union("tfoot").union("tr");
    private static final HTMLElementNameSet _THEAD_TBODY_TFOOT_TR_TD_TH = new HTMLElementNameSet(_THEAD_TBODY_TFOOT_TR).union("td").union("th");
    private static final HTMLElementNameSet DEPRECATED = new HTMLElementNameSet().union("applet").union("basefont").union("center").union("dir").union("font").union("isindex").union("menu").union("s").union("strike").union("u");
    private static final HTMLElementNameSet START_TAG_OPTIONAL_SET = new HTMLElementNameSet().union("body").union("head").union("html").union("tbody");
    private static final HashMap<String, String> CONSTANT_NAME_MAP = HTMLElements.buildTagMap();
    private static final HashMap<String, HTMLElementTerminatingTagNameSets> TERMINATING_TAG_NAME_SETS_MAP = HTMLElements.buildTerminatingTagNameSetsMap();
    private static final Set<String> END_TAG_OPTIONAL_SET = TERMINATING_TAG_NAME_SETS_MAP.keySet();
    private static final HTMLElementNameSet END_TAG_REQUIRED_SET = new HTMLElementNameSet().union(ALL).minus(END_TAG_FORBIDDEN_SET).minus(END_TAG_OPTIONAL_SET);
    private static final HTMLElementNameSet CLOSING_SLASH_IGNORED_SET = new HTMLElementNameSet().union(END_TAG_OPTIONAL_SET).union(END_TAG_REQUIRED_SET);
    static final HTMLElementNameSet END_TAG_REQUIRED_NESTING_FORBIDDEN_SET = new HTMLElementNameSet().union("a").union("address").union("applet").union("button").union("caption").union("datalist").union("form").union("hgroup").union("iframe").union("label").union("legend").union("optgroup").union("script").union("select").union("style").union("textarea").union("title");
    private static final HTMLElementNameSet END_TAG_OPTIONAL_NESTING_FORBIDDEN_SET = new HTMLElementNameSet().union("body").union("colgroup").union("head").union("html").union("option").union("p").union("rp").union("rt");
    private static final HTMLElementNameSet NESTING_FORBIDDEN_SET = new HTMLElementNameSet().union(END_TAG_REQUIRED_NESTING_FORBIDDEN_SET).union(END_TAG_OPTIONAL_NESTING_FORBIDDEN_SET).union(END_TAG_FORBIDDEN_SET);

    private HTMLElements() {
    }

    public static final List<String> getElementNames() {
        return ALL;
    }

    public static Set<String> getBlockLevelElementNames() {
        return BLOCK;
    }

    public static Set<String> getInlineLevelElementNames() {
        return INLINE;
    }

    public static Set<String> getDeprecatedElementNames() {
        return DEPRECATED;
    }

    public static Set<String> getEndTagForbiddenElementNames() {
        return END_TAG_FORBIDDEN_SET;
    }

    public static Set<String> getEndTagOptionalElementNames() {
        return END_TAG_OPTIONAL_SET;
    }

    public static Set<String> getEndTagRequiredElementNames() {
        return END_TAG_REQUIRED_SET;
    }

    public static Set<String> getStartTagOptionalElementNames() {
        return START_TAG_OPTIONAL_SET;
    }

    public static Set<String> getTerminatingStartTagNames(String string) {
        HTMLElementTerminatingTagNameSets hTMLElementTerminatingTagNameSets = HTMLElements.getTerminatingTagNameSets(string);
        if (hTMLElementTerminatingTagNameSets == null) {
            return null;
        }
        return hTMLElementTerminatingTagNameSets.TerminatingStartTagNameSet;
    }

    public static Set<String> getTerminatingEndTagNames(String string) {
        HTMLElementTerminatingTagNameSets hTMLElementTerminatingTagNameSets = HTMLElements.getTerminatingTagNameSets(string);
        if (hTMLElementTerminatingTagNameSets == null) {
            return null;
        }
        return hTMLElementTerminatingTagNameSets.TerminatingEndTagNameSet;
    }

    public static Set<String> getNonterminatingElementNames(String string) {
        HTMLElementTerminatingTagNameSets hTMLElementTerminatingTagNameSets = HTMLElements.getTerminatingTagNameSets(string);
        if (hTMLElementTerminatingTagNameSets == null) {
            return null;
        }
        return hTMLElementTerminatingTagNameSets.NonterminatingElementNameSet;
    }

    public static Set<String> getNestingForbiddenElementNames() {
        return NESTING_FORBIDDEN_SET;
    }

    static final String getConstantElementName(String string) {
        String string2 = CONSTANT_NAME_MAP.get(string);
        return string2 != null ? string2 : string;
    }

    static final boolean isClosingSlashIgnored(String string) {
        if (Config.IsHTMLEmptyElementTagRecognised) {
            return false;
        }
        return CLOSING_SLASH_IGNORED_SET.contains(string);
    }

    static final HTMLElementTerminatingTagNameSets getTerminatingTagNameSets(String string) {
        return TERMINATING_TAG_NAME_SETS_MAP.get(string);
    }

    private static HashMap<String, HTMLElementTerminatingTagNameSets> buildTerminatingTagNameSetsMap() {
        HashMap<String, HTMLElementTerminatingTagNameSets> hashMap = new HashMap<String, HTMLElementTerminatingTagNameSets>(20, 1.0f);
        hashMap.put("body", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(), new HTMLElementNameSet("html").union("body"), new HTMLElementNameSet("html")));
        hashMap.put("colgroup", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(_THEAD_TBODY_TFOOT_TR).union("colgroup"), new HTMLElementNameSet("table").union("colgroup"), new HTMLElementNameSet("table")));
        hashMap.put("dd", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(_DD_DT), new HTMLElementNameSet("dl").union("dd"), new HTMLElementNameSet("dl")));
        hashMap.put("dt", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(_DD_DT), new HTMLElementNameSet("dl").union("dt"), new HTMLElementNameSet("dl")));
        hashMap.put("head", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet("body").union("frameset"), new HTMLElementNameSet("html").union("head"), new HTMLElementNameSet()));
        hashMap.put("html", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(), new HTMLElementNameSet("html"), new HTMLElementNameSet("html")));
        hashMap.put("li", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet("li"), new HTMLElementNameSet(_UL_OL).union("li"), new HTMLElementNameSet(_UL_OL)));
        hashMap.put("option", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet("option").union("optgroup"), new HTMLElementNameSet("select").union("option"), new HTMLElementNameSet()));
        hashMap.put("p", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(BLOCK).union(_DD_DT).union("th").union("td").union("li"), new HTMLElementNameSet(BLOCK).union(_DD_DT).union("body").union("html").union(_THEAD_TBODY_TFOOT_TR_TD_TH).union("caption").union("legend"), new HTMLElementNameSet()));
        hashMap.put("rp", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet("rp").union("rt"), new HTMLElementNameSet("ruby"), new HTMLElementNameSet()));
        hashMap.put("rt", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet("rp").union("rt"), new HTMLElementNameSet("ruby"), new HTMLElementNameSet()));
        hashMap.put("tbody", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet("tbody").union("tfoot").union("thead"), new HTMLElementNameSet("table").union("tbody"), new HTMLElementNameSet("table")));
        hashMap.put("td", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(_THEAD_TBODY_TFOOT_TR_TD_TH), new HTMLElementNameSet(_THEAD_TBODY_TFOOT_TR).union("table").union("td"), new HTMLElementNameSet("table")));
        hashMap.put("tfoot", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet("tbody").union("tfoot").union("thead"), new HTMLElementNameSet("table").union("tfoot"), new HTMLElementNameSet("table")));
        hashMap.put("th", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(_THEAD_TBODY_TFOOT_TR_TD_TH), new HTMLElementNameSet(_THEAD_TBODY_TFOOT_TR).union("table").union("th"), new HTMLElementNameSet("table")));
        hashMap.put("thead", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet("tbody").union("tfoot").union("thead"), new HTMLElementNameSet("table").union("thead"), new HTMLElementNameSet("table")));
        hashMap.put("tr", new HTMLElementTerminatingTagNameSets(new HTMLElementNameSet(_THEAD_TBODY_TFOOT_TR), new HTMLElementNameSet(_THEAD_TBODY_TFOOT_TR).union("table"), new HTMLElementNameSet("table")));
        return hashMap;
    }

    private static HashMap<String, String> buildTagMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>(132, 1.0f);
        for (String string : ALL) {
            hashMap.put(string, string);
        }
        hashMap.put("!element", "!element");
        hashMap.put("!attlist", "!attlist");
        hashMap.put("!entity", "!entity");
        hashMap.put("!notation", "!notation");
        hashMap.put("![if", "![if");
        hashMap.put("![endif", "![endif");
        return hashMap;
    }
}

