/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.select;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.nodes.Element;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.org.jsoup.select.Evaluator;

@RelocatedClass
@Generated
@SuppressFBWarnings
abstract class StructuralEvaluator
extends Evaluator {
    Evaluator evaluator;

    StructuralEvaluator() {
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static class ImmediatePreviousSibling
    extends StructuralEvaluator {
        public ImmediatePreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            Element prev = element.previousElementSibling();
            return prev != null && this.evaluator.matches(root, prev);
        }

        public String toString() {
            return String.format(":prev%s", this.evaluator);
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static class PreviousSibling
    extends StructuralEvaluator {
        public PreviousSibling(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            for (Element prev = element.previousElementSibling(); prev != null; prev = prev.previousElementSibling()) {
                if (!this.evaluator.matches(root, prev)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format(":prev*%s", this.evaluator);
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static class ImmediateParent
    extends StructuralEvaluator {
        public ImmediateParent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            Element parent = element.parent();
            return parent != null && this.evaluator.matches(root, parent);
        }

        public String toString() {
            return String.format(":ImmediateParent%s", this.evaluator);
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static class Parent
    extends StructuralEvaluator {
        public Parent(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            if (root == element) {
                return false;
            }
            Element parent = element.parent();
            while (true) {
                if (this.evaluator.matches(root, parent)) {
                    return true;
                }
                if (parent == root) break;
                parent = parent.parent();
            }
            return false;
        }

        public String toString() {
            return String.format(":parent%s", this.evaluator);
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static class Not
    extends StructuralEvaluator {
        public Not(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element node) {
            return !this.evaluator.matches(root, node);
        }

        public String toString() {
            return String.format(":not%s", this.evaluator);
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static class Has
    extends StructuralEvaluator {
        public Has(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public boolean matches(Element root, Element element) {
            for (Element e : element.getAllElements()) {
                if (e == element || !this.evaluator.matches(element, e)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format(":has(%s)", this.evaluator);
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    static class Root
    extends Evaluator {
        Root() {
        }

        @Override
        public boolean matches(Element root, Element element) {
            return root == element;
        }
    }
}

