/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.CharacterReference;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Config;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.EndTag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Segment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StartTag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Tag;

@RelocatedClass
@Generated
@SuppressFBWarnings
public final class Attribute
extends Segment {
    private final String key;
    private final Segment nameSegment;
    private final Segment valueSegment;
    private final Segment valueSegmentIncludingQuotes;
    StartTag startTag = StartTag.NOT_CACHED;
    static final String CHECKED = "checked";
    static final String CLASS = "class";
    static final String DISABLED = "disabled";
    static final String ID = "id";
    static final String MULTIPLE = "multiple";
    static final String NAME = "name";
    static final String SELECTED = "selected";
    static final String STYLE = "style";
    static final String TYPE = "type";
    static final String VALUE = "value";

    Attribute(Source source, String string, Segment segment) {
        this(source, string, segment, null, null);
    }

    Attribute(Source source, String string, Segment segment, Segment segment2, Segment segment3) {
        super(source, segment.getBegin(), segment3 == null ? segment.getEnd() : segment3.getEnd());
        this.key = string;
        this.nameSegment = segment;
        this.valueSegment = segment2;
        this.valueSegmentIncludingQuotes = segment3;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.nameSegment.toString();
    }

    public Segment getNameSegment() {
        return this.nameSegment;
    }

    public boolean hasValue() {
        return this.valueSegment != null;
    }

    public String getValue() {
        return CharacterReference.decode(this.valueSegment, true);
    }

    public Segment getValueSegment() {
        return this.valueSegment;
    }

    public Segment getValueSegmentIncludingQuotes() {
        return this.valueSegmentIncludingQuotes;
    }

    public char getQuoteChar() {
        if (this.valueSegment == this.valueSegmentIncludingQuotes) {
            return ' ';
        }
        return this.source.charAt(this.valueSegmentIncludingQuotes.getBegin());
    }

    public StartTag getStartTag() {
        if (this.startTag == StartTag.NOT_CACHED) {
            Tag tag = this.source.getEnclosingTag(this.begin);
            this.startTag = tag == null || tag instanceof EndTag ? null : (StartTag)tag;
        }
        return this.startTag;
    }

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder().append(this.key).append(super.getDebugInfo()).append(",name=").append(this.nameSegment.getDebugInfo());
        if (this.hasValue()) {
            stringBuilder.append(",value=").append(this.valueSegment.getDebugInfo()).append('\"').append(this.valueSegment).append('\"').append(Config.NewLine);
        } else {
            stringBuilder.append(",NO VALUE").append(Config.NewLine);
        }
        return stringBuilder.toString();
    }

    Tag appendTidy(Appendable appendable, Tag tag) throws IOException {
        appendable.append(' ').append(this.nameSegment);
        if (this.valueSegment != null) {
            appendable.append("=\"");
            while (tag != null && tag.begin < this.valueSegment.begin) {
                tag = tag.getNextTag();
            }
            if (tag == null || tag.begin >= this.valueSegment.end) {
                Attribute.appendTidyValue(appendable, this.valueSegment);
            } else {
                int n = this.valueSegment.begin;
                while (tag != null && tag.begin < this.valueSegment.end) {
                    Attribute.appendTidyValue(appendable, new Segment(this.source, n, tag.begin));
                    if (tag.end > this.valueSegment.end) {
                        n = this.valueSegment.end;
                        appendable.append(new Segment(this.source, tag.begin, n));
                        break;
                    }
                    appendable.append(tag);
                    n = tag.end;
                    tag = tag.getNextTag();
                }
                if (n < this.valueSegment.end) {
                    Attribute.appendTidyValue(appendable, new Segment(this.source, n, this.valueSegment.end));
                }
            }
            appendable.append('\"');
        }
        return tag;
    }

    private static void appendTidyValue(Appendable appendable, CharSequence charSequence) throws IOException {
        CharacterReference.appendEncode(appendable, CharacterReference.decode(charSequence, true), true);
    }

    static Appendable appendHTML(Appendable appendable, CharSequence charSequence, CharSequence charSequence2) throws IOException {
        appendable.append(' ').append(charSequence);
        if (charSequence2 != null) {
            appendable.append("=\"");
            CharacterReference.appendEncode(appendable, charSequence2, true);
            appendable.append('\"');
        }
        return appendable;
    }
}

