/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classpath;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashSet;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classpath.CallStackReader;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.scanspec.ScanSpec;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;

@RelocatedClass
@Generated
@SuppressFBWarnings
public class ClassLoaderFinder {
    private final ClassLoader[] contextClassLoaders;

    public ClassLoader[] getContextClassLoaders() {
        return this.contextClassLoaders;
    }

    ClassLoaderFinder(ScanSpec scanSpec, LogNode log) {
        LogNode classLoadersFoundLog;
        LinkedHashSet<Object> classLoadersUnique;
        if (scanSpec.overrideClassLoaders == null) {
            block11: {
                ClassLoader systemClassLoader;
                ClassLoader classLoader;
                classLoadersUnique = new LinkedHashSet();
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                if (threadClassLoader != null) {
                    classLoadersUnique.add(threadClassLoader);
                }
                if ((classLoader = this.getClass().getClassLoader()) != null) {
                    classLoadersUnique.add(classLoader);
                }
                if ((systemClassLoader = ClassLoader.getSystemClassLoader()) != null) {
                    classLoadersUnique.add(systemClassLoader);
                }
                try {
                    Class<?>[] callStack = CallStackReader.getClassContext(log);
                    for (int i2 = callStack.length - 1; i2 >= 0; --i2) {
                        ClassLoader callerClassLoader = callStack[i2].getClassLoader();
                        if (callerClassLoader == null) continue;
                        classLoadersUnique.add(callerClassLoader);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (log == null) break block11;
                    log.log("Could not get call stack", e);
                }
            }
            if (scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new LinkedHashSet<ClassLoader>(scanSpec.overrideClassLoaders);
            LogNode logNode = classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoadersUnique) {
                classLoadersFoundLog.log(classLoader.getClass().getName());
            }
        }
        this.contextClassLoaders = classLoadersUnique.toArray(new ClassLoader[0]);
    }
}

