/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classpath;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.io.github.classgraph.ClassGraph;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.classpath.SystemJarFinder;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.scanspec.ScanSpec;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.FastPathResolver;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.FileUtils;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.JarUtils;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.LogNode;

@RelocatedClass
@Generated
@SuppressFBWarnings
public class ClasspathOrder {
    private final ScanSpec scanSpec;
    private final Set<String> classpathEntryUniqueResolvedPaths = new HashSet<String>();
    private final List<ClasspathElementAndClassLoader> order = new ArrayList<ClasspathElementAndClassLoader>();
    private static final List<String> AUTOMATIC_PACKAGE_ROOT_SUFFIXES = new ArrayList<String>();

    ClasspathOrder(ScanSpec scanSpec) {
        this.scanSpec = scanSpec;
    }

    public List<ClasspathElementAndClassLoader> getOrder() {
        return this.order;
    }

    public Set<String> getClasspathEntryUniqueResolvedPaths() {
        return this.classpathEntryUniqueResolvedPaths;
    }

    private boolean filter(String classpathElementPath) {
        if (this.scanSpec.classpathElementFilters != null) {
            for (ClassGraph.ClasspathElementFilter filter : this.scanSpec.classpathElementFilters) {
                if (filter.includeClasspathElement(classpathElementPath)) continue;
                return false;
            }
        }
        return true;
    }

    boolean addSystemClasspathEntry(String pathEntry, ClassLoader classLoader) {
        if (this.classpathEntryUniqueResolvedPaths.add(pathEntry)) {
            this.order.add(new ClasspathElementAndClassLoader(pathEntry, classLoader));
            return true;
        }
        return false;
    }

    private boolean addClasspathEntry(Object pathElement, String pathElementStr, ClassLoader classLoader, ScanSpec scanSpec) {
        String pathElementStrWithoutSuffix = pathElementStr;
        boolean hasSuffix = false;
        for (String suffix : AUTOMATIC_PACKAGE_ROOT_SUFFIXES) {
            if (!pathElementStr.endsWith(suffix)) continue;
            pathElementStrWithoutSuffix = pathElementStr.substring(0, pathElementStr.length() - suffix.length());
            hasSuffix = true;
            break;
        }
        if (pathElement instanceof URL || pathElement instanceof URI || pathElement instanceof Path || pathElement instanceof File) {
            Object pathElementWithoutSuffix = pathElement;
            if (hasSuffix) {
                try {
                    pathElementWithoutSuffix = pathElement instanceof URL ? new URL(pathElementStrWithoutSuffix) : (pathElement instanceof URI ? new URI(pathElementStrWithoutSuffix) : (pathElement instanceof Path ? Paths.get(pathElementStrWithoutSuffix, new String[0]) : pathElementStrWithoutSuffix));
                }
                catch (MalformedURLException | URISyntaxException | InvalidPathException e) {
                    return false;
                }
            }
            if (this.classpathEntryUniqueResolvedPaths.add(pathElementStrWithoutSuffix)) {
                this.order.add(new ClasspathElementAndClassLoader(pathElementWithoutSuffix, classLoader));
                return true;
            }
        } else {
            String pathElementStrResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, pathElementStrWithoutSuffix);
            if (scanSpec.overrideClasspath == null && (SystemJarFinder.getJreLibOrExtJars().contains(pathElementStrResolved) || pathElementStrResolved.equals(SystemJarFinder.getJreRtJarPath()))) {
                return false;
            }
            if (this.classpathEntryUniqueResolvedPaths.add(pathElementStrResolved)) {
                this.order.add(new ClasspathElementAndClassLoader(pathElementStrResolved, classLoader));
                return true;
            }
        }
        return false;
    }

    public boolean addClasspathEntry(Object pathElement, ClassLoader classLoader, ScanSpec scanSpec, LogNode log) {
        if (pathElement == null) {
            return false;
        }
        String pathElementStr = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, pathElement.toString());
        if (pathElementStr.isEmpty()) {
            return false;
        }
        if (pathElement instanceof URL || pathElement instanceof URI || pathElement instanceof File) {
            String classpathElementObj;
            if (!this.filter(pathElementStr)) {
                if (log != null) {
                    log.log("Classpath element did not match filter criterion, skipping: " + pathElementStr);
                }
                return false;
            }
            try {
                classpathElementObj = pathElement instanceof File ? pathElementStr : (pathElement instanceof URI ? ((URI)pathElement).toURL() : pathElement);
            }
            catch (MalformedURLException e) {
                if (log != null) {
                    log.log("Cannot convert from URI to URL: " + pathElementStr);
                }
                return false;
            }
            if (this.addClasspathEntry((Object)classpathElementObj, pathElementStr, classLoader, scanSpec)) {
                if (log != null) {
                    log.log("Found classpath element: " + pathElementStr);
                }
                return true;
            }
            if (log != null) {
                log.log("Ignoring duplicate classpath element: " + pathElementStr);
            }
            return false;
        }
        if (pathElementStr.endsWith("*")) {
            if (pathElementStr.length() == 1 || pathElementStr.length() > 2 && pathElementStr.charAt(pathElementStr.length() - 1) == '*' && (pathElementStr.charAt(pathElementStr.length() - 2) == File.separatorChar || File.separatorChar != '/' && pathElementStr.charAt(pathElementStr.length() - 2) == '/')) {
                String baseDirPath = pathElementStr.length() == 1 ? "" : pathElementStr.substring(0, pathElementStr.length() - 2);
                String baseDirPathResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, baseDirPath);
                if (!this.filter(baseDirPath) || !baseDirPathResolved.equals(baseDirPath) && !this.filter(baseDirPathResolved)) {
                    if (log != null) {
                        log.log("Classpath element did not match filter criterion, skipping: " + pathElementStr);
                    }
                    return false;
                }
                File baseDir = new File(baseDirPathResolved);
                if (!baseDir.exists()) {
                    if (log != null) {
                        log.log("Directory does not exist for wildcard classpath element: " + pathElementStr);
                    }
                    return false;
                }
                if (!FileUtils.canRead(baseDir)) {
                    if (log != null) {
                        log.log("Cannot read directory for wildcard classpath element: " + pathElementStr);
                    }
                    return false;
                }
                if (!baseDir.isDirectory()) {
                    if (log != null) {
                        log.log("Wildcard is appended to something other than a directory: " + pathElementStr);
                    }
                    return false;
                }
                LogNode dirLog = log == null ? null : log.log("Adding classpath elements from wildcarded directory: " + pathElementStr);
                File[] baseDirFiles = baseDir.listFiles();
                if (baseDirFiles != null) {
                    for (File fileInDir : baseDirFiles) {
                        String name = fileInDir.getName();
                        if (name.equals(".") || name.equals("..")) continue;
                        String fileInDirPath = fileInDir.getPath();
                        String fileInDirPathResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, fileInDirPath);
                        if (this.addClasspathEntry((Object)fileInDirPathResolved, fileInDirPathResolved, classLoader, scanSpec)) {
                            if (dirLog == null) continue;
                            dirLog.log("Found classpath element: " + fileInDirPath + (fileInDirPath.equals(fileInDirPathResolved) ? "" : " -> " + fileInDirPathResolved));
                            continue;
                        }
                        if (dirLog == null) continue;
                        dirLog.log("Ignoring duplicate classpath element: " + fileInDirPath + (fileInDirPath.equals(fileInDirPathResolved) ? "" : " -> " + fileInDirPathResolved));
                    }
                    return true;
                }
                return false;
            }
            if (log != null) {
                log.log("Wildcard classpath elements can only end with a leaf of \"*\", can't have a partial name and then a wildcard: " + pathElementStr);
            }
            return false;
        }
        String pathElementResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, pathElementStr);
        if (!this.filter(pathElementStr) || !pathElementResolved.equals(pathElementStr) && !this.filter(pathElementResolved)) {
            if (log != null) {
                log.log("Classpath element did not match filter criterion, skipping: " + pathElementStr + (pathElementStr.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
            }
            return false;
        }
        if (this.addClasspathEntry((Object)pathElementResolved, pathElementResolved, classLoader, scanSpec)) {
            if (log != null) {
                log.log("Found classpath element: " + pathElementStr + (pathElementStr.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
            }
            return true;
        }
        if (log != null) {
            log.log("Ignoring duplicate classpath element: " + pathElementStr + (pathElementStr.equals(pathElementResolved) ? "" : " -> " + pathElementResolved));
        }
        return false;
    }

    public boolean addClasspathEntries(List<Object> overrideClasspath, ClassLoader classLoader, ScanSpec scanSpec, LogNode log) {
        if (overrideClasspath == null || overrideClasspath.isEmpty()) {
            return false;
        }
        for (Object pathElement : overrideClasspath) {
            this.addClasspathEntry(pathElement, classLoader, scanSpec, log);
        }
        return true;
    }

    public boolean addClasspathPathStr(String pathStr, ClassLoader classLoader, ScanSpec scanSpec, LogNode log) {
        if (pathStr == null || pathStr.isEmpty()) {
            return false;
        }
        String[] parts = JarUtils.smartPathSplit(pathStr, scanSpec);
        if (parts.length == 0) {
            return false;
        }
        for (String pathElement : parts) {
            this.addClasspathEntry((Object)pathElement, classLoader, scanSpec, log);
        }
        return true;
    }

    public boolean addClasspathEntryObject(Object pathObject, ClassLoader classLoader, ScanSpec scanSpec, LogNode log) {
        boolean valid = false;
        if (pathObject != null) {
            if (pathObject instanceof URL || pathObject instanceof URI || pathObject instanceof Path || pathObject instanceof File) {
                valid |= this.addClasspathEntry(pathObject, classLoader, scanSpec, log);
            } else if (pathObject instanceof Iterable) {
                for (Object elt : (Iterable)pathObject) {
                    valid |= this.addClasspathEntryObject(elt, classLoader, scanSpec, log);
                }
            } else {
                Class<?> valClass = pathObject.getClass();
                if (valClass.isArray()) {
                    int n = Array.getLength(pathObject);
                    for (int j = 0; j < n; ++j) {
                        Object elt = Array.get(pathObject, j);
                        valid |= this.addClasspathEntryObject(elt, classLoader, scanSpec, log);
                    }
                } else {
                    valid |= this.addClasspathPathStr(pathObject.toString(), classLoader, scanSpec, log);
                }
            }
        }
        return valid;
    }

    static {
        for (String prefix : ClassLoaderHandlerRegistry.AUTOMATIC_PACKAGE_ROOT_PREFIXES) {
            AUTOMATIC_PACKAGE_ROOT_SUFFIXES.add("!/" + prefix.substring(0, prefix.length() - 1));
        }
    }

    @RelocatedClass
    @Generated
    @SuppressFBWarnings
    public static class ClasspathElementAndClassLoader {
        public final Object classpathElementRoot;
        public final String dirOrPathPackageRoot;
        public final ClassLoader classLoader;

        public ClasspathElementAndClassLoader(Object classpathElementRoot, String dirOrPathPackageRoot, ClassLoader classLoader) {
            this.classpathElementRoot = classpathElementRoot;
            this.dirOrPathPackageRoot = dirOrPathPackageRoot;
            this.classLoader = classLoader;
        }

        public ClasspathElementAndClassLoader(Object classpathElementRoot, ClassLoader classLoader) {
            this.classpathElementRoot = classpathElementRoot;
            this.dirOrPathPackageRoot = "";
            this.classLoader = classLoader;
        }

        public int hashCode() {
            return Objects.hash(this.classpathElementRoot, this.dirOrPathPackageRoot, this.classLoader);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClasspathElementAndClassLoader)) {
                return false;
            }
            ClasspathElementAndClassLoader other = (ClasspathElementAndClassLoader)obj;
            return Objects.equals(this.dirOrPathPackageRoot, other.dirOrPathPackageRoot) && Objects.equals(this.classpathElementRoot, other.classpathElementRoot) && Objects.equals(this.classLoader, other.classLoader);
        }

        public String toString() {
            return this.classpathElementRoot + " [" + this.classLoader + "]";
        }
    }
}

