/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Deque;
import java.util.LinkedList;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.Position;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.PrettyPrinterConfiguration;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.utils.Utils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class SourcePrinter {
    private final String endOfLineCharacter;
    private final String indentation;
    private final int tabWidth;
    private final PrettyPrinterConfiguration.IndentType indentType;
    private final Deque<String> indents = new LinkedList<String>();
    private final Deque<String> reindentedIndents = new LinkedList<String>();
    private String lastPrintedIndent = "";
    private final StringBuilder buf = new StringBuilder();
    private Position cursor = new Position(1, 0);
    private boolean indented = false;

    SourcePrinter() {
        this(new PrettyPrinterConfiguration());
    }

    SourcePrinter(PrettyPrinterConfiguration configuration) {
        this.indentation = configuration.getIndent();
        this.endOfLineCharacter = configuration.getEndOfLineCharacter();
        this.tabWidth = configuration.getTabWidth();
        this.indentType = configuration.getIndentType();
        this.indents.push("");
    }

    public SourcePrinter indent() {
        String currentIndent = this.indents.peek();
        switch (this.indentType) {
            case SPACES: 
            case TABS_WITH_SPACE_ALIGN: {
                this.indents.push(currentIndent + this.indentation);
                break;
            }
            case TABS: {
                this.indents.push(this.indentation + currentIndent);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        return this;
    }

    public SourcePrinter indentWithAlignTo(int column) {
        this.indents.push(this.calculateIndentWithAlignTo(column));
        return this;
    }

    private String calculateIndentWithAlignTo(int column) {
        if (column < this.lastPrintedIndent.length()) {
            throw new IllegalStateException("Attempt to indent less than the previous indent.");
        }
        StringBuilder newIndent = new StringBuilder(this.lastPrintedIndent);
        switch (this.indentType) {
            case SPACES: 
            case TABS_WITH_SPACE_ALIGN: {
                while (newIndent.length() < column) {
                    newIndent.append(' ');
                }
                break;
            }
            case TABS: {
                int logicalIndentLength = newIndent.length();
                while (logicalIndentLength + this.tabWidth <= column) {
                    newIndent.insert(0, '\t');
                    logicalIndentLength += this.tabWidth;
                }
                while (logicalIndentLength < column) {
                    newIndent.append(' ');
                    ++logicalIndentLength;
                }
                StringBuilder fullTab = new StringBuilder();
                for (int i2 = 0; i2 < this.tabWidth; ++i2) {
                    fullTab.append(' ');
                }
                String fullTabString = fullTab.toString();
                if (newIndent.length() < this.tabWidth || !newIndent.substring(newIndent.length() - this.tabWidth).equals(fullTabString)) break;
                int i3 = newIndent.indexOf(fullTabString);
                newIndent.replace(i3, i3 + this.tabWidth, "\t");
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        return newIndent.toString();
    }

    public SourcePrinter unindent() {
        if (this.indents.isEmpty()) {
            throw new IllegalStateException("Indent/unindent calls are not well-balanced.");
        }
        this.indents.pop();
        return this;
    }

    private void append(String arg) {
        this.buf.append(arg);
        this.cursor = this.cursor.withColumn(this.cursor.column + arg.length());
    }

    public SourcePrinter print(String arg) {
        if (!this.indented) {
            this.lastPrintedIndent = this.indents.peek();
            this.append(this.lastPrintedIndent);
            this.indented = true;
        }
        this.append(arg);
        return this;
    }

    public SourcePrinter println(String arg) {
        this.print(arg);
        this.println();
        return this;
    }

    public SourcePrinter println() {
        this.buf.append(this.endOfLineCharacter);
        this.cursor = new Position(this.cursor.line + 1, 0);
        this.indented = false;
        return this;
    }

    public Position getCursor() {
        return this.cursor;
    }

    @Deprecated
    public String getSource() {
        return this.toString();
    }

    public String toString() {
        return this.buf.toString();
    }

    public String normalizeEolInTextBlock(String content) {
        return Utils.normalizeEolInTextBlock(content, this.endOfLineCharacter);
    }

    public void reindentWithAlignToCursor() {
        String newIndent = this.calculateIndentWithAlignTo(this.cursor.column);
        this.reindentedIndents.push(this.indents.pop());
        this.indents.push(newIndent);
    }

    public void reindentToPreviousLevel() {
        if (this.reindentedIndents.isEmpty()) {
            throw new IllegalStateException("Reindent calls are not well-balanced.");
        }
        this.indents.pop();
        this.indents.push(this.reindentedIndents.pop());
    }

    public void duplicateIndent() {
        this.indents.push(this.indents.peek());
    }
}

