/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.annotations.GwtCompatible;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.google.common.base.Preconditions;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("null key in entry: null=" + value);
        }
        if (value == null) {
            throw new NullPointerException("null value in entry: " + key + "=null");
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    @CanIgnoreReturnValue
    static long checkNonnegative(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    static void checkPositive(int value, String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(name + " must be positive but was: " + value);
        }
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

