/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Attributes;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.EndTag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.FormControl;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Segment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StartTag;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public final class Element
extends Segment {
    private final StartTag startTag;
    private final EndTag endTag;
    private Segment content = null;
    Element parentElement = NOT_CACHED;
    private int depth = -1;
    private List<Element> childElements = null;
    static final Element NOT_CACHED = new Element();
    private static final boolean INCLUDE_INCORRECTLY_NESTED_CHILDREN_IN_HIERARCHY = true;

    Element(Source source, StartTag startTag, EndTag endTag) {
        super(source, startTag.begin, endTag == null ? startTag.end : endTag.end);
        if (source.isStreamed()) {
            throw new UnsupportedOperationException("Elements are not supported when using StreamedSource");
        }
        this.startTag = startTag;
        this.endTag = endTag == null || endTag.length() == 0 ? null : endTag;
    }

    private Element() {
        this.startTag = null;
        this.endTag = null;
    }

    public Element getParentElement() {
        if (this.parentElement == NOT_CACHED) {
            if (!this.source.wasFullSequentialParseCalled()) {
                throw new IllegalStateException("This operation is only possible after a full sequential parse has been performed");
            }
            if (this.startTag.isOrphaned()) {
                throw new IllegalStateException("This operation is only possible if a full sequential parse was performed immediately after construction of the Source object");
            }
            this.source.getChildElements();
            if (this.parentElement == NOT_CACHED) {
                this.parentElement = null;
            }
        }
        return this.parentElement;
    }

    @Override
    public final List<Element> getChildElements() {
        return this.childElements != null ? this.childElements : this.getChildElements(-1);
    }

    final List<Element> getChildElements(int n) {
        if (n != -1) {
            this.depth = n;
        }
        if (this.childElements == null) {
            if (this.end == this.startTag.end) {
                this.childElements = Collections.emptyList();
            } else {
                StartTag startTag;
                int n2;
                int n3 = n == -1 ? -1 : n + 1;
                this.childElements = new ArrayList<Element>();
                int n4 = this.startTag.end;
                int n5 = n2 = this.endTag == null ? this.end : this.endTag.begin;
                while ((startTag = this.source.getNextStartTag(n4)) != null && startTag.begin < n2) {
                    if (startTag.getTagType().isServerTag()) {
                        n4 = startTag.end;
                        continue;
                    }
                    Element element = startTag.getElement();
                    if (element.end > this.end && this.source.logger.isErrorEnabled()) {
                        this.source.logger.error("Child " + element.getDebugInfo() + " extends beyond end of parent " + this.getDebugInfo());
                    }
                    element.getChildElements(n3);
                    if (element.parentElement == NOT_CACHED) {
                        element.parentElement = this;
                        this.childElements.add(element);
                    }
                    n4 = element.end;
                }
            }
        }
        return this.childElements;
    }

    public int getDepth() {
        if (this.depth == -1) {
            this.getParentElement();
            if (this.depth == -1) {
                this.depth = 0;
            }
        }
        return this.depth;
    }

    public Segment getContent() {
        if (this.content == null) {
            this.content = new Segment(this.source, this.startTag.end, this.getContentEnd());
        }
        return this.content;
    }

    public StartTag getStartTag() {
        return this.startTag;
    }

    public EndTag getEndTag() {
        return this.endTag;
    }

    public String getName() {
        return this.startTag.getName();
    }

    @Override
    public boolean isEmpty() {
        return this.startTag.end == this.getContentEnd();
    }

    public boolean isEmptyElementTag() {
        return this.startTag.isEmptyElementTag();
    }

    public Attributes getAttributes() {
        return this.getStartTag().getAttributes();
    }

    public String getAttributeValue(String string) {
        return this.getStartTag().getAttributeValue(string);
    }

    public FormControl getFormControl() {
        return FormControl.construct(this);
    }

    @Override
    public String getDebugInfo() {
        if (this == NOT_CACHED) {
            return "NOT_CACHED";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Element ");
        this.startTag.appendDebugTag(stringBuilder);
        if (!this.isEmpty()) {
            stringBuilder.append('-');
        }
        if (this.endTag != null) {
            stringBuilder.append(this.endTag);
        }
        stringBuilder.append(' ');
        this.startTag.appendDebugTagType(stringBuilder);
        stringBuilder.append(super.getDebugInfo());
        return stringBuilder.toString();
    }

    int getContentEnd() {
        return this.endTag != null ? this.endTag.begin : this.end;
    }
}

