/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Attribute;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Attributes;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Element;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.EndTag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.EndTagType;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.FormControl;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.HTMLElementTerminatingTagNameSets;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.HTMLElements;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.ParseText;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Segment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StartTagType;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Tag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.TagType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public final class StartTag
extends Tag {
    private final Attributes attributes;
    final StartTagType startTagType;
    static final StartTag NOT_CACHED = (StartTag)Tag.NOT_CACHED;

    StartTag(Source source, int n, int n2, StartTagType startTagType, String string, Attributes attributes2) {
        super(source, n, n2, string);
        this.attributes = attributes2;
        this.startTagType = startTagType;
        if (attributes2 != null) {
            attributes2.setStartTag(this);
        }
    }

    StartTag() {
        this.attributes = null;
        this.startTagType = null;
    }

    @Override
    public Element getElement() {
        if (this.element == Element.NOT_CACHED) {
            EndTag endTag = this.getEndTagInternal();
            this.element = new Element(this.source, this, endTag);
            if (endTag != null) {
                if (endTag.element != Element.NOT_CACHED && this.source.logger.isErrorEnabled() && !this.element.equals(endTag.element)) {
                    this.source.logger.error(this.source.getRowColumnVector(endTag.begin).appendTo(new StringBuilder(200).append("End tag ").append(endTag).append(" at ")).append(" terminates more than one element").toString());
                }
                endTag.element = this.element;
            }
        }
        return this.element;
    }

    public boolean isEmptyElementTag() {
        return this.isSyntacticalEmptyElementTag() && !HTMLElements.isClosingSlashIgnored(this.name);
    }

    public boolean isSyntacticalEmptyElementTag() {
        return this.startTagType == StartTagType.NORMAL && this.source.charAt(this.end - 2) == '/';
    }

    public StartTagType getStartTagType() {
        return this.startTagType;
    }

    @Override
    public TagType getTagType() {
        return this.startTagType;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String string) {
        return this.attributes == null ? null : this.attributes.getValue(string);
    }

    @Override
    public Attributes parseAttributes() {
        return this.parseAttributes(Attributes.getDefaultMaxErrorCount());
    }

    public Attributes parseAttributes(int n) {
        if (this.attributes != null) {
            return this.attributes;
        }
        int n2 = this.end - this.startTagType.getClosingDelimiter().length();
        int n3 = this.begin + 1 + this.name.length();
        while (!StartTag.isXMLNameStartChar(this.source.charAt(n3))) {
            if (++n3 != n2) continue;
            return null;
        }
        Attributes attributes2 = Attributes.construct(this.source, this.begin, n3, n2, this.startTagType, this.name, n);
        if (attributes2 != null) {
            attributes2.setStartTag(this);
        }
        return attributes2;
    }

    public Segment getTagContent() {
        return new Segment(this.source, this.begin + 1 + this.name.length(), this.end - this.startTagType.getClosingDelimiter().length());
    }

    public FormControl getFormControl() {
        return this.getElement().getFormControl();
    }

    public boolean isEndTagForbidden() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() == null;
        }
        if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return this.isSyntacticalEmptyElementTag();
    }

    public boolean isEndTagRequired() {
        if (this.getStartTagType() != StartTagType.NORMAL) {
            return this.getStartTagType().getCorrespondingEndTagType() != null;
        }
        if (HTMLElements.getEndTagRequiredElementNames().contains(this.name)) {
            return true;
        }
        if (HTMLElements.getElementNames().contains(this.name)) {
            return false;
        }
        return !this.isSyntacticalEmptyElementTag();
    }

    @Override
    public boolean isUnregistered() {
        return this.startTagType == StartTagType.UNREGISTERED;
    }

    @Override
    public String tidy() {
        return this.tidy(false);
    }

    public String tidy(boolean bl) {
        if (this.attributes == null || this.attributes.containsServerTagOutsideOfAttributeValue) {
            return this.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        if (bl && this.startTagType == StartTagType.NORMAL) {
            stringBuilder.append(this.name);
        } else {
            int n;
            int n2 = n + this.name.length();
            for (n = this.begin + this.startTagType.startDelimiterPrefix.length(); n < n2; ++n) {
                stringBuilder.append(this.source.charAt(n));
            }
        }
        try {
            this.attributes.appendTidy(stringBuilder, this.getNextTag());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.startTagType == StartTagType.NORMAL && this.getElement().getEndTag() == null && !HTMLElements.getEndTagOptionalElementNames().contains(this.name)) {
            stringBuilder.append(" /");
        }
        stringBuilder.append(this.startTagType.getClosingDelimiter());
        return stringBuilder.toString();
    }

    public static String generateHTML(String string, Map<String, String> map, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<').append(string);
        try {
            Attributes.appendHTML(stringBuilder, map);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (bl) {
            stringBuilder.append(" />");
        } else {
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendDebugTag(stringBuilder);
        stringBuilder.append(' ');
        this.appendDebugTagType(stringBuilder);
        stringBuilder.append(super.getDebugInfo());
        return stringBuilder.toString();
    }

    StringBuilder appendDebugTag(StringBuilder stringBuilder) {
        if (this.startTagType == StartTagType.NORMAL && this.getAttributes().isEmpty()) {
            stringBuilder.append(this);
        } else {
            stringBuilder.append('<').append(this.getNameSegment()).append(' ');
            if (this.isSyntacticalEmptyElementTag()) {
                stringBuilder.append('/');
            }
            stringBuilder.append(this.startTagType.getClosingDelimiter());
        }
        return stringBuilder;
    }

    StringBuilder appendDebugTagType(StringBuilder stringBuilder) {
        if (this.startTagType != StartTagType.NORMAL) {
            stringBuilder.append('(').append(this.startTagType.getDescription()).append(") ");
        }
        return stringBuilder;
    }

    private EndTag getEndTagInternal() {
        Object object;
        boolean bl = true;
        EndTagType endTagType = this.startTagType.getCorrespondingEndTagType();
        if (this.startTagType == StartTagType.NORMAL) {
            boolean bl2 = bl = !HTMLElements.isClosingSlashIgnored(this.name);
            if (bl && this.isSyntacticalEmptyElementTag()) {
                return null;
            }
            if (HTMLElements.getEndTagForbiddenElementNames().contains(this.name)) {
                return null;
            }
            object = HTMLElements.getTerminatingTagNameSets(this.name);
            if (object != null) {
                return this.getOptionalEndTag((HTMLElementTerminatingTagNameSets)object);
            }
        } else if (endTagType == null) {
            return null;
        }
        if ((object = this.source.getNextEndTag(this.end, endTagType.getEndTagName(this.name), endTagType)) != null) {
            if (this.startTagType == StartTagType.NORMAL && HTMLElements.END_TAG_REQUIRED_NESTING_FORBIDDEN_SET.contains(this.name)) {
                StartTag startTag = this.source.getNextStartTag(this.end, this.name);
                if (startTag == null || startTag.begin > ((EndTag)object).begin) {
                    return object;
                }
                if (this.source.logger.isErrorEnabled()) {
                    this.source.logger.error(this.source.getRowColumnVector(this.begin).appendTo(new StringBuilder(200).append("StartTag at ")).append(" missing required end tag - invalid nested start tag encountered before end tag").toString());
                }
                return new EndTag(this.source, startTag.begin, startTag.begin, EndTagType.NORMAL, this.name);
            }
            Segment[] segmentArray = this.getEndTag((EndTag)object, bl, Tag.isXMLName(this.name));
            if (segmentArray != null) {
                return (EndTag)segmentArray[0];
            }
        }
        if (this.source.logger.isErrorEnabled()) {
            this.source.logger.error(this.source.getRowColumnVector(this.begin).appendTo(new StringBuilder(200).append("StartTag at ")).append(" missing required end tag").toString());
        }
        return null;
    }

    private EndTag getOptionalEndTag(HTMLElementTerminatingTagNameSets hTMLElementTerminatingTagNameSets) {
        Tag tag;
        int n = this.end;
        while (n < this.source.end && (tag = Tag.getNextTag(this.source, n)) != null) {
            Set<String> set;
            if (tag instanceof EndTag) {
                if (tag.name == this.name) {
                    return (EndTag)tag;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingEndTagNameSet;
            } else {
                set = hTMLElementTerminatingTagNameSets.NonterminatingElementNameSet;
                if (set != null && set.contains(tag.name)) {
                    Element element = ((StartTag)tag).getElement();
                    n = element.end;
                    continue;
                }
                set = hTMLElementTerminatingTagNameSets.TerminatingStartTagNameSet;
            }
            if (set != null && set.contains(tag.name)) {
                return new EndTag(this.source, tag.begin, tag.begin, EndTagType.NORMAL, this.name);
            }
            n = tag.begin + 1;
        }
        return new EndTag(this.source, this.source.end, this.source.end, EndTagType.NORMAL, this.name);
    }

    static String getStartDelimiter(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("searchName argument must not be zero length");
        }
        String string2 = "<" + string;
        if (string2.charAt("<".length()) == '/') {
            throw new IllegalArgumentException("searchName argument \"" + string + "\" must not start with '/'");
        }
        return string2;
    }

    static StartTag getPrevious(Source source, int n, String string, StartTagType startTagType) {
        return StartTag.getPrevious(source, n, string, startTagType, startTagType == StartTagType.NORMAL ? Tag.isXMLName(string) : true);
    }

    static StartTag getPrevious(Source source, int n, String string, StartTagType startTagType, boolean bl) {
        if (string == null) {
            return (StartTag)source.getPreviousTag(n, startTagType);
        }
        if (source.wasFullSequentialParseCalled() && bl) {
            StartTag startTag = (StartTag)Tag.getPreviousTag(source, n, startTagType);
            while (true) {
                if (startTag == null) {
                    return null;
                }
                if (startTag.name.equals(string)) {
                    return startTag;
                }
                if (startTag.name.startsWith(string) && startTag.isPartialNameSearchMatch(string)) {
                    return startTag;
                }
                if (startTag.name.length() < string.length() && source.getParseText().containsAt(string, startTag.begin + startTagType.startDelimiterPrefix.length())) {
                    return startTag;
                }
                startTag = (StartTag)startTag.getPreviousTag(startTagType);
            }
        }
        String string2 = StartTag.getStartDelimiter(string);
        ParseText parseText = source.getParseText();
        int n2 = n;
        do {
            if ((n2 = parseText.lastIndexOf(string2, n2)) == -1) {
                return null;
            }
            StartTag startTag = (StartTag)Tag.getTagAt(source, n2, false);
            if (startTag == null || startTagType != startTag.getStartTagType() && (startTagType != StartTagType.NORMAL || bl || !startTag.isUnregistered()) || startTag.getName().length() > string.length() && !startTag.isPartialNameSearchMatch(string)) continue;
            return startTag;
        } while ((n2 -= 2) >= 0);
        return null;
    }

    final boolean isPartialNameSearchMatch(String string) {
        char c = string.charAt(string.length() - 1);
        return c == ':' || !StartTag.isXMLNameChar(c);
    }

    static StartTag getNext(Source source, int n, String string, StartTagType startTagType) {
        return StartTag.getNext(source, n, string, startTagType, startTagType == StartTagType.NORMAL ? Tag.isXMLName(string) : true);
    }

    static StartTag getNext(Source source, int n, String string, StartTagType startTagType, boolean bl) {
        if (string == null) {
            return (StartTag)source.getNextTag(n, startTagType);
        }
        if (source.wasFullSequentialParseCalled() && bl) {
            StartTag startTag = (StartTag)Tag.getNextTag(source, n, startTagType);
            while (true) {
                if (startTag == null) {
                    return null;
                }
                if (startTag.name.equals(string)) {
                    return startTag;
                }
                if (startTag.name.startsWith(string) && startTag.isPartialNameSearchMatch(string)) {
                    return startTag;
                }
                if (startTag.name.length() < string.length() && source.getParseText().containsAt(string, startTag.begin + startTagType.startDelimiterPrefix.length())) {
                    return startTag;
                }
                startTag = (StartTag)startTag.getNextTag(startTagType);
            }
        }
        String string2 = StartTag.getStartDelimiter(string);
        try {
            ParseText parseText = source.getParseText();
            int n2 = n;
            do {
                if ((n2 = parseText.indexOf(string2, n2)) == -1) {
                    return null;
                }
                StartTag startTag = (StartTag)Tag.getTagAt(source, n2, false);
                if (startTag == null || startTagType != startTag.getStartTagType() && (startTagType != StartTagType.NORMAL || bl || !startTag.isUnregistered()) || startTag.getName().length() > string.length() && !startTag.isPartialNameSearchMatch(string)) continue;
                return startTag;
            } while (++n2 < source.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static StartTag getPrevious(Source source, int n) {
        Tag tag = Tag.getPreviousTag(source, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof StartTag) {
            return (StartTag)tag;
        }
        return tag.getPreviousStartTag();
    }

    static StartTag getNext(Source source, int n) {
        Tag tag = Tag.getNextTag(source, n);
        if (tag == null) {
            return null;
        }
        if (tag instanceof StartTag) {
            return (StartTag)tag;
        }
        return tag.getNextStartTag();
    }

    static StartTag getNext(Source source, int n, String string, String string2, boolean bl) {
        if (string2 == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (source.wasFullSequentialParseCalled()) {
            StartTag startTag = source.getNextStartTag(n);
            while (true) {
                if (startTag == null) {
                    return null;
                }
                if (startTag.hasAttribute(string, string2, bl)) {
                    return startTag;
                }
                startTag = startTag.getNextStartTag();
            }
        }
        String string3 = string2.length() >= 3 || string2.length() > 0 && string.length() < 3 ? string2 : string;
        ParseText parseText = source.getParseText();
        int n2 = n;
        while (n2 < source.end) {
            StartTag startTag;
            n2 = parseText.indexOf(string3.toLowerCase(), n2);
            if (n2 == -1) {
                return null;
            }
            Tag tag = source.getEnclosingTag(n2);
            if (tag == null || !(tag instanceof StartTag)) {
                ++n2;
                continue;
            }
            if (tag.begin >= n && (startTag = (StartTag)tag).hasAttribute(string, string2, bl)) {
                return startTag;
            }
            n2 = tag.end;
        }
        return null;
    }

    boolean hasAttribute(String string, String string2, boolean bl) {
        if (this.attributes == null) {
            return false;
        }
        String string3 = this.attributes.getValue(string);
        if (string3 == null) {
            return false;
        }
        if (string2.equals(string3)) {
            return true;
        }
        if ((!bl || this.source.logger.isWarnEnabled()) && string2.equalsIgnoreCase(string3)) {
            if (!bl) {
                return true;
            }
            if (this.source.logger.isWarnEnabled()) {
                this.source.logger.warn(this.getRowColumnVector().appendTo(new StringBuilder(200)).append(": StartTag with attribute ").append(string).append("=\"").append(string3).append("\" ignored during search because its case does not match search value \"").append(string2).append('\"').toString());
            }
        }
        return false;
    }

    static StartTag getNext(Source source, int n, String string, Pattern pattern) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (source.wasFullSequentialParseCalled()) {
            StartTag startTag = source.getNextStartTag(n);
            while (true) {
                if (startTag == null) {
                    return null;
                }
                if (startTag.hasAttribute(string, pattern)) {
                    return startTag;
                }
                startTag = startTag.getNextStartTag();
            }
        }
        String string2 = string;
        ParseText parseText = source.getParseText();
        int n2 = n;
        while (n2 < source.end) {
            StartTag startTag;
            n2 = parseText.indexOf(string2.toLowerCase(), n2);
            if (n2 == -1) {
                return null;
            }
            Tag tag = source.getEnclosingTag(n2);
            if (tag == null || !(tag instanceof StartTag)) {
                ++n2;
                continue;
            }
            if (tag.begin >= n && (startTag = (StartTag)tag).hasAttribute(string, pattern)) {
                return startTag;
            }
            n2 = tag.end;
        }
        return null;
    }

    boolean hasAttribute(String string, Pattern pattern) {
        if (this.attributes == null) {
            return false;
        }
        Attribute attribute = this.attributes.get(string);
        if (attribute == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        String string2 = attribute.getValue();
        return string2 != null && pattern.matcher(string2).matches();
    }

    private Segment[] getEndTag(EndTag endTag, boolean bl, boolean bl2) {
        assert (endTag != null);
        StartTag startTag = StartTag.getNext(this.source, this.end, this.name, this.startTagType, bl2);
        if (bl) {
            while (startTag != null && startTag.isSyntacticalEmptyElementTag()) {
                startTag = StartTag.getNext(this.source, startTag.end, this.name, this.startTagType, bl2);
            }
        }
        return this.getEndTag(this.end, startTag, endTag, bl, bl2);
    }

    private Segment[] getEndTag(int n, StartTag startTag, EndTag endTag, boolean bl, boolean bl2) {
        if (endTag == null) {
            return null;
        }
        Segment[] segmentArray = new Segment[]{endTag, startTag};
        if (startTag == null || startTag.begin > endTag.begin) {
            return segmentArray;
        }
        Segment[] segmentArray2 = startTag.getEndTag(endTag, bl, bl2);
        if (segmentArray2 == null) {
            return null;
        }
        EndTag endTag2 = (EndTag)segmentArray2[0];
        EndTag endTag3 = EndTag.getNext(this.source, endTag2.end, endTag.getName(), endTag.getEndTagType());
        return this.getEndTag(endTag2.end, (StartTag)segmentArray2[1], endTag3, bl, bl2);
    }
}

