/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Attribute;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Element;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.ParseText;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Segment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StartTag;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
final class URIAttributes {
    private static final String[] uriAttributeNames = new String[]{"action", "archive", "background", "cite", "href", "longdesc", "src", "usemap"};
    private static final String[] objectURIAttributeNames = new String[]{"classid", "codebase", "data"};

    URIAttributes() {
    }

    public static List<Attribute> getList(Segment segment) {
        Attribute attribute;
        if (segment == null || segment.getFirstStartTag() == null) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (String string : uriAttributeNames) {
            for (StartTag charSequence : segment.getAllStartTags(string, null)) {
                attribute = charSequence.getAttributes().get(string);
                attribute.startTag = charSequence;
                arrayList.add(attribute);
            }
        }
        for (StartTag startTag : segment.getAllStartTags("object")) {
            for (String string : objectURIAttributeNames) {
                attribute = startTag.getAttributes().get(string);
                if (attribute == null) continue;
                attribute.startTag = startTag;
                arrayList.add(attribute);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static List<Segment> getStyleURISegments(Segment segment) {
        if (segment == null || segment.length() == 0) {
            return Collections.emptyList();
        }
        if (segment.getFirstStartTag() == null) {
            int n = segment.getSource().getParseText().indexOf("url(", segment.getBegin(), segment.getEnd());
            if (n == -1) {
                return Collections.emptyList();
            }
            return URIAttributes.addURLSegmentsFromCSS(new ArrayList<Segment>(), new Segment(segment.getSource(), n, segment.getEnd()));
        }
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        for (StartTag segment2 : segment.getAllStartTags("style", null)) {
            URIAttributes.addURLSegmentsFromCSS(arrayList, segment2.getAttributes().get("style").getValueSegment());
        }
        for (Element element : segment.getAllElements("style")) {
            URIAttributes.addURLSegmentsFromCSS(arrayList, element.getContent());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private static List<Segment> addURLSegmentsFromCSS(List<Segment> list, Segment segment) {
        Source source = segment.getSource();
        ParseText parseText = source.getParseText();
        int n = segment.getEnd();
        int n2 = segment.getBegin();
        while ((n2 = parseText.indexOf("url(", n2, n)) != -1) {
            int n3;
            int n4;
            int n5;
            n2 += 4;
            while (n2 < n && Segment.isWhiteSpace(parseText.charAt(n2))) {
                ++n2;
            }
            if (n2 >= n || URIAttributes.isQuote(parseText.charAt(n2)) && ++n2 >= n || (n5 = parseText.indexOf(')', n4 = n2, n)) == -1) break;
            n2 = n5;
            while (Segment.isWhiteSpace(parseText.charAt(n2 - 1))) {
                --n2;
            }
            if (URIAttributes.isQuote(parseText.charAt(n2 - 1))) {
                // empty if block
            }
            if ((n3 = --n2) <= n4) break;
            list.add(new Segment(source, n4, n3));
            n2 = n5;
        }
        return list;
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }
}

