/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.dsl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PluginId {
    @NotNull
    private final String id;
    @NotNull
    private final Set<String> alternateIds;

    public PluginId(@NotNull String id2, @NotNull Collection<String> alternateIds) {
        this.id = id2;
        LinkedHashSet<String> alternateIdsSet = new LinkedHashSet<String>(alternateIds);
        alternateIdsSet.remove(id2);
        this.alternateIds = alternateIds.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(alternateIdsSet);
    }

    public PluginId(@NotNull String id2, String ... alternateIds) {
        this(id2, Arrays.asList(alternateIds));
    }

    public PluginId(@NotNull String id2) {
        this.id = id2;
        this.alternateIds = Collections.emptySet();
    }

    public PluginId(@NotNull PluginId primary, PluginId ... others) {
        this(primary.getId(), Stream.concat(primary.getAlternateIds().stream(), Stream.of(others).flatMap(it -> Stream.concat(Stream.of(it.getId()), it.getAlternateIds().stream()))).collect(Collectors.toList()));
    }

    public PluginId(@NotNull PluginId primary) {
        this.id = primary.getId();
        this.alternateIds = primary.getAlternateIds();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Set<String> getAlternateIds() {
        return this.alternateIds;
    }

    @NotNull
    public final Set<String> getAllIds() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        result2.add(this.id);
        result2.addAll(this.alternateIds);
        return result2;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginId)) {
            return false;
        }
        PluginId pluginId2 = (PluginId)o;
        return Objects.equals(this.id, pluginId2.id) && Objects.equals(this.alternateIds, pluginId2.alternateIds);
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.alternateIds);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", alternateIds=" + this.alternateIds + '}';
    }
}

