/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.Optional;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.Position;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.TokenRange;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.utils.Utils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class Problem {
    private final String message;
    private final TokenRange location;
    private final Throwable cause;
    public static Comparator<Problem> PROBLEM_BY_BEGIN_POSITION = (a2, b2) -> {
        Optional aBegin = a2.getLocation().flatMap(l -> l.getBegin().getRange().map(r -> r.begin));
        Optional bBegin = b2.getLocation().flatMap(l -> l.getBegin().getRange().map(r -> r.begin));
        if (aBegin.isPresent() && bBegin.isPresent()) {
            return ((Position)aBegin.get()).compareTo((Position)bBegin.get());
        }
        if (a2.getLocation().isPresent() || b2.getLocation().isPresent()) {
            if (a2.getLocation().isPresent()) {
                return 1;
            }
            return -1;
        }
        return 0;
    };

    public Problem(String message2, TokenRange location, Throwable cause) {
        Utils.assertNotNull(message2);
        this.message = message2;
        this.location = location;
        this.cause = cause;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getVerboseMessage());
        if (this.cause != null) {
            str.append(Utils.SYSTEM_EOL).append("Problem stacktrace : ").append(Utils.SYSTEM_EOL);
            for (int i2 = 0; i2 < this.cause.getStackTrace().length; ++i2) {
                StackTraceElement ste = this.cause.getStackTrace()[i2];
                str.append("  ").append(ste.toString());
                if (i2 + 1 == this.cause.getStackTrace().length) continue;
                str.append(Utils.SYSTEM_EOL);
            }
        }
        return str.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public String getVerboseMessage() {
        return this.getLocation().map(l -> l.getBegin().getRange().map(r -> r.begin.toString()).orElse("(line ?,col ?)") + " " + this.message).orElse(this.message);
    }

    public Optional<TokenRange> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this.cause);
    }
}

