/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.expr;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.TokenRange;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.AllFieldsConstructor;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.Node;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.expr.LiteralStringValueExpr;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.visitor.CloneVisitor;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.visitor.GenericVisitor;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.visitor.VoidVisitor;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.metamodel.IntegerLiteralExprMetaModel;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.metamodel.JavaParserMetaModel;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.utils.Utils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public class IntegerLiteralExpr
extends LiteralStringValueExpr {
    public static final String MAX_31_BIT_UNSIGNED_VALUE_AS_STRING = "2147483648";
    public static final long MAX_31_BIT_UNSIGNED_VALUE_AS_LONG = 0x80000000L;

    public IntegerLiteralExpr() {
        this(null, "0");
    }

    @AllFieldsConstructor
    public IntegerLiteralExpr(String value) {
        this(null, value);
    }

    public IntegerLiteralExpr(TokenRange tokenRange, String value) {
        super(tokenRange, value);
        this.customInitialization();
    }

    @Deprecated
    public IntegerLiteralExpr(int value) {
        this(null, String.valueOf(value));
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        return super.remove(node);
    }

    @Deprecated
    public int asInt() {
        String result2 = this.value.replaceAll("_", "");
        if (result2.startsWith("0x") || result2.startsWith("0X")) {
            return Integer.parseUnsignedInt(result2.substring(2), 16);
        }
        if (result2.startsWith("0b") || result2.startsWith("0B")) {
            return Integer.parseUnsignedInt(result2.substring(2), 2);
        }
        if (result2.length() > 1 && result2.startsWith("0")) {
            return Integer.parseUnsignedInt(result2.substring(1), 8);
        }
        return Integer.parseInt(result2);
    }

    public Number asNumber() {
        if (Objects.equals(this.value, MAX_31_BIT_UNSIGNED_VALUE_AS_STRING) && Utils.hasUnaryMinusAsParent(this)) {
            return 0x80000000L;
        }
        return this.asInt();
    }

    @Deprecated
    public IntegerLiteralExpr setInt(int value) {
        this.value = String.valueOf(value);
        return this;
    }

    @Override
    public IntegerLiteralExpr clone() {
        return (IntegerLiteralExpr)this.accept(new CloneVisitor(), null);
    }

    @Override
    public IntegerLiteralExprMetaModel getMetaModel() {
        return JavaParserMetaModel.integerLiteralExprMetaModel;
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        return super.replace(node, replacementNode);
    }

    @Override
    public boolean isIntegerLiteralExpr() {
        return true;
    }

    @Override
    public IntegerLiteralExpr asIntegerLiteralExpr() {
        return this;
    }

    @Override
    public void ifIntegerLiteralExpr(Consumer<IntegerLiteralExpr> action) {
        action.accept(this);
    }

    @Override
    public Optional<IntegerLiteralExpr> toIntegerLiteralExpr() {
        return Optional.of(this);
    }
}

