/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.Node;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.body.VariableDeclarator;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.ast.type.Type;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.concretesyntaxmodel.CsmIndent;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.concretesyntaxmodel.CsmMix;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.concretesyntaxmodel.CsmToken;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.concretesyntaxmodel.CsmUnindent;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.Added;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.ChildTextElement;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.DifferenceElement;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.Kept;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.NodeText;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.Removed;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.Reshuffled;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.TextElement;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
class DifferenceElementCalculator {
    DifferenceElementCalculator() {
    }

    static boolean matching(CsmElement a2, CsmElement b2) {
        if (a2 instanceof LexicalDifferenceCalculator.CsmChild) {
            if (b2 instanceof LexicalDifferenceCalculator.CsmChild) {
                LexicalDifferenceCalculator.CsmChild childA = (LexicalDifferenceCalculator.CsmChild)a2;
                LexicalDifferenceCalculator.CsmChild childB = (LexicalDifferenceCalculator.CsmChild)b2;
                return childA.getChild().equals(childB.getChild());
            }
            if (b2 instanceof CsmToken) {
                return false;
            }
            if (b2 instanceof CsmIndent) {
                return false;
            }
            if (b2 instanceof CsmUnindent) {
                return false;
            }
            throw new UnsupportedOperationException(a2.getClass().getSimpleName() + " " + b2.getClass().getSimpleName());
        }
        if (a2 instanceof CsmToken) {
            if (b2 instanceof CsmToken) {
                CsmToken childA = (CsmToken)a2;
                CsmToken childB = (CsmToken)b2;
                return childA.equals(childB);
            }
            if (b2 instanceof LexicalDifferenceCalculator.CsmChild) {
                return false;
            }
            if (b2 instanceof CsmIndent) {
                return false;
            }
            if (b2 instanceof CsmUnindent) {
                return false;
            }
            throw new UnsupportedOperationException(a2.getClass().getSimpleName() + " " + b2.getClass().getSimpleName());
        }
        if (a2 instanceof CsmIndent) {
            return b2 instanceof CsmIndent;
        }
        if (a2 instanceof CsmUnindent) {
            return b2 instanceof CsmUnindent;
        }
        throw new UnsupportedOperationException(a2.getClass().getSimpleName() + " " + b2.getClass().getSimpleName());
    }

    private static boolean replacement(CsmElement a2, CsmElement b2) {
        if (a2 instanceof CsmIndent || b2 instanceof CsmIndent || a2 instanceof CsmUnindent || b2 instanceof CsmUnindent) {
            return false;
        }
        if (a2 instanceof LexicalDifferenceCalculator.CsmChild) {
            if (b2 instanceof LexicalDifferenceCalculator.CsmChild) {
                LexicalDifferenceCalculator.CsmChild childA = (LexicalDifferenceCalculator.CsmChild)a2;
                LexicalDifferenceCalculator.CsmChild childB = (LexicalDifferenceCalculator.CsmChild)b2;
                return childA.getChild().getClass().equals(childB.getChild().getClass());
            }
            if (b2 instanceof CsmToken) {
                return false;
            }
            throw new UnsupportedOperationException(a2.getClass().getSimpleName() + " " + b2.getClass().getSimpleName());
        }
        if (a2 instanceof CsmToken) {
            if (b2 instanceof CsmToken) {
                CsmToken childA = (CsmToken)a2;
                CsmToken childB = (CsmToken)b2;
                return childA.getTokenType() == childB.getTokenType();
            }
            if (b2 instanceof LexicalDifferenceCalculator.CsmChild) {
                return false;
            }
        }
        throw new UnsupportedOperationException(a2.getClass().getSimpleName() + " " + b2.getClass().getSimpleName());
    }

    private static Map<Node, Integer> findChildrenPositions(LexicalDifferenceCalculator.CalculatedSyntaxModel calculatedSyntaxModel) {
        HashMap<Node, Integer> positions = new HashMap<Node, Integer>();
        for (int i2 = 0; i2 < calculatedSyntaxModel.elements.size(); ++i2) {
            CsmElement element = calculatedSyntaxModel.elements.get(i2);
            if (!(element instanceof LexicalDifferenceCalculator.CsmChild)) continue;
            positions.put(((LexicalDifferenceCalculator.CsmChild)element).getChild(), i2);
        }
        return positions;
    }

    static List<DifferenceElement> calculate(LexicalDifferenceCalculator.CalculatedSyntaxModel original, LexicalDifferenceCalculator.CalculatedSyntaxModel after) {
        Map<Node, Integer> childrenInOriginal = DifferenceElementCalculator.findChildrenPositions(original);
        Map<Node, Integer> childrenInAfter = DifferenceElementCalculator.findChildrenPositions(after);
        LinkedList<Node> commonChildren = new LinkedList<Node>(childrenInOriginal.keySet());
        commonChildren.retainAll(childrenInAfter.keySet());
        commonChildren.sort(Comparator.comparingInt(childrenInOriginal::get));
        LinkedList<DifferenceElement> elements = new LinkedList<DifferenceElement>();
        int originalIndex = 0;
        int afterIndex = 0;
        int commonChildrenIndex = 0;
        while (commonChildrenIndex < commonChildren.size()) {
            Node child = (Node)commonChildren.get(commonChildrenIndex++);
            int posOfNextChildInOriginal = childrenInOriginal.get(child);
            int posOfNextChildInAfter = childrenInAfter.get(child);
            if (originalIndex < posOfNextChildInOriginal || afterIndex < posOfNextChildInAfter) {
                elements.addAll(DifferenceElementCalculator.calculateImpl(original.sub(originalIndex, posOfNextChildInOriginal), after.sub(afterIndex, posOfNextChildInAfter)));
            }
            elements.add(new Kept(new LexicalDifferenceCalculator.CsmChild(child)));
            originalIndex = posOfNextChildInOriginal + 1;
            afterIndex = posOfNextChildInAfter + 1;
        }
        if (originalIndex < original.elements.size() || afterIndex < after.elements.size()) {
            elements.addAll(DifferenceElementCalculator.calculateImpl(original.sub(originalIndex, original.elements.size()), after.sub(afterIndex, after.elements.size())));
        }
        return elements;
    }

    private static void considerRemoval(NodeText nodeTextForChild, List<DifferenceElement> elements) {
        for (TextElement el : nodeTextForChild.getElements()) {
            if (el instanceof ChildTextElement) {
                ChildTextElement cte = (ChildTextElement)el;
                DifferenceElementCalculator.considerRemoval(LexicalPreservingPrinter.getOrCreateNodeText(cte.getChild()), elements);
                continue;
            }
            if (el instanceof TokenTextElement) {
                TokenTextElement tte = (TokenTextElement)el;
                elements.add(new Removed(new CsmToken(tte.getTokenKind(), tte.getText())));
                continue;
            }
            throw new UnsupportedOperationException(el.toString());
        }
    }

    private static int considerRemoval(CsmElement removedElement, int originalIndex, List<DifferenceElement> elements) {
        LexicalDifferenceCalculator.CsmChild removedChild;
        boolean dealtWith = false;
        if (removedElement instanceof LexicalDifferenceCalculator.CsmChild && (removedChild = (LexicalDifferenceCalculator.CsmChild)removedElement).getChild() instanceof Type && removedChild.getChild().getParentNode().isPresent() && removedChild.getChild().getParentNode().get() instanceof VariableDeclarator) {
            NodeText nodeTextForChild = LexicalPreservingPrinter.getOrCreateNodeText(removedChild.getChild());
            DifferenceElementCalculator.considerRemoval(nodeTextForChild, elements);
            ++originalIndex;
            dealtWith = true;
        }
        if (!dealtWith) {
            elements.add(new Removed(removedElement));
            ++originalIndex;
        }
        return originalIndex;
    }

    private static List<DifferenceElement> calculateImpl(LexicalDifferenceCalculator.CalculatedSyntaxModel original, LexicalDifferenceCalculator.CalculatedSyntaxModel after) {
        LinkedList<DifferenceElement> elements = new LinkedList<DifferenceElement>();
        int originalIndex = 0;
        int afterIndex = 0;
        do {
            if (originalIndex < original.elements.size() && afterIndex >= after.elements.size()) {
                CsmElement removedElement = original.elements.get(originalIndex);
                originalIndex = DifferenceElementCalculator.considerRemoval(removedElement, originalIndex, elements);
                continue;
            }
            if (originalIndex >= original.elements.size() && afterIndex < after.elements.size()) {
                elements.add(new Added(after.elements.get(afterIndex)));
                ++afterIndex;
                continue;
            }
            CsmElement nextOriginal = original.elements.get(originalIndex);
            CsmElement nextAfter = after.elements.get(afterIndex);
            if (nextOriginal instanceof CsmMix && nextAfter instanceof CsmMix) {
                if (((CsmMix)nextAfter).getElements().equals(((CsmMix)nextOriginal).getElements())) {
                    ((CsmMix)nextAfter).getElements().forEach(el -> elements.add(new Kept((CsmElement)el)));
                } else {
                    elements.add(new Reshuffled((CsmMix)nextOriginal, (CsmMix)nextAfter));
                }
                ++originalIndex;
                ++afterIndex;
                continue;
            }
            if (DifferenceElementCalculator.matching(nextOriginal, nextAfter)) {
                elements.add(new Kept(nextOriginal));
                ++originalIndex;
                ++afterIndex;
                continue;
            }
            if (DifferenceElementCalculator.replacement(nextOriginal, nextAfter)) {
                originalIndex = DifferenceElementCalculator.considerRemoval(nextOriginal, originalIndex, elements);
                elements.add(new Added(nextAfter));
                ++afterIndex;
                continue;
            }
            List<DifferenceElement> addingElements = DifferenceElementCalculator.calculate(original.from(originalIndex), after.from(afterIndex + 1));
            List<DifferenceElement> removingElements = null;
            if (DifferenceElementCalculator.cost(addingElements) > 0L) {
                removingElements = DifferenceElementCalculator.calculate(original.from(originalIndex + 1), after.from(afterIndex));
            }
            if (removingElements == null || DifferenceElementCalculator.cost(removingElements) > DifferenceElementCalculator.cost(addingElements)) {
                elements.add(new Added(nextAfter));
                ++afterIndex;
                continue;
            }
            elements.add(new Removed(nextOriginal));
            ++originalIndex;
        } while (originalIndex < original.elements.size() || afterIndex < after.elements.size());
        return elements;
    }

    private static long cost(List<DifferenceElement> elements) {
        return elements.stream().filter(e -> !(e instanceof Kept)).count();
    }

    static void removeIndentationElements(List<DifferenceElement> elements) {
        elements.removeIf(el -> el.getElement() instanceof CsmIndent || el.getElement() instanceof CsmUnindent);
    }
}

