/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Element;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.EndTag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.EndTagType;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.HTMLElements;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.ParseText;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Segment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StartTag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StartTagType;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.TagType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class Tag
extends Segment {
    String name = null;
    private Object userData = null;
    Element element = Element.NOT_CACHED;
    private Tag previousTag = NOT_CACHED;
    private Tag nextTag = NOT_CACHED;
    static final Tag NOT_CACHED = new StartTag();
    private static final boolean INCLUDE_UNREGISTERED_IN_SEARCH = false;

    Tag(Source source2, int n, int n2, String string) {
        super(source2, n, n2);
        this.name = HTMLElements.getConstantElementName(string.toLowerCase());
    }

    Tag() {
    }

    public abstract Element getElement();

    public final String getName() {
        return this.name;
    }

    public Segment getNameSegment() {
        int n = this.begin + this.getTagType().startDelimiterPrefix.length();
        return new Segment(this.source, n, n + this.name.length());
    }

    public abstract TagType getTagType();

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Tag getNextTag() {
        if (this.nextTag == NOT_CACHED) {
            Tag tag = Tag.getNextTag(this.source, this.begin + 1);
            if (this.source.wasFullSequentialParseCalled()) {
                return tag;
            }
            this.nextTag = tag;
        }
        return this.nextTag;
    }

    public Tag getPreviousTag() {
        if (this.previousTag == NOT_CACHED) {
            this.previousTag = Tag.getPreviousTag(this.source, this.begin - 1);
        }
        return this.previousTag;
    }

    public abstract boolean isUnregistered();

    public abstract String tidy();

    public static final boolean isXMLName(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0 || !Tag.isXMLNameStartChar(charSequence.charAt(0))) {
            return false;
        }
        for (int j = 1; j < charSequence.length(); ++j) {
            if (Tag.isXMLNameChar(charSequence.charAt(j))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isXMLNameStartChar(char c) {
        return Character.isLetter(c) || c == '_' || c == ':';
    }

    public static final boolean isXMLNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':';
    }

    StartTag getNextStartTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getNextTag()) != null) continue;
            return null;
        } while (!(tag instanceof StartTag));
        return (StartTag)tag;
    }

    StartTag getPreviousStartTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getPreviousTag()) != null) continue;
            return null;
        } while (!(tag instanceof StartTag));
        return (StartTag)tag;
    }

    EndTag getNextEndTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getNextTag()) != null) continue;
            return null;
        } while (!(tag instanceof EndTag));
        return (EndTag)tag;
    }

    EndTag getPreviousEndTag() {
        Tag tag = this;
        do {
            if ((tag = tag.getPreviousTag()) != null) continue;
            return null;
        } while (!(tag instanceof EndTag));
        return (EndTag)tag;
    }

    Tag getNextTag(TagType tagType) {
        if (tagType == null) {
            return this.getNextTag();
        }
        if (tagType == StartTagType.UNREGISTERED || tagType == EndTagType.UNREGISTERED) {
            return Tag.getNextTag(this.source, this.begin + 1, tagType);
        }
        Tag tag = this;
        do {
            if (tag.nextTag == NOT_CACHED) {
                return Tag.getNextTag(this.source, tag.begin + 1, tagType);
            }
            tag = tag.nextTag;
            if (tag != null) continue;
            return null;
        } while (tag.getTagType() != tagType);
        return tag;
    }

    Tag getPreviousTag(TagType tagType) {
        if (tagType == null) {
            return this.getPreviousTag();
        }
        if (tagType == StartTagType.UNREGISTERED || tagType == EndTagType.UNREGISTERED) {
            return Tag.getPreviousTag(this.source, this.begin - 1, tagType);
        }
        Tag tag = this;
        do {
            if (tag.previousTag == NOT_CACHED) {
                return Tag.getPreviousTag(this.source, tag.begin - 1, tagType);
            }
            tag = tag.previousTag;
            if (tag != null) continue;
            return null;
        } while (tag.getTagType() != tagType);
        return tag;
    }

    final boolean includeInSearch() {
        return !this.isUnregistered();
    }

    static final Tag getPreviousTag(Source source2, int n) {
        return source2.useAllTypesCache ? source2.cache.getPreviousTag(n) : Tag.getPreviousTagUncached(source2, n, -1);
    }

    static final Tag getNextTag(Source source2, int n) {
        return source2.useAllTypesCache ? source2.cache.getNextTag(n) : Tag.getNextTagUncached(source2, n, -1);
    }

    static final Tag getPreviousTagUncached(Source source2, int n, int n2) {
        try {
            ParseText parseText = source2.getParseText();
            int n3 = n;
            do {
                if ((n3 = parseText.lastIndexOf('<', n3, n2)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source2, n3, false);
                if (tag == null || !tag.includeInSearch()) continue;
                return tag;
            } while (--n3 >= 0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new AssertionError((Object)"Unexpected internal exception");
        }
        return null;
    }

    static final Tag getNextTagUncached(Source source2, int n, int n2) {
        try {
            ParseText parseText = source2.getParseText();
            int n3 = n;
            do {
                if ((n3 = parseText.indexOf('<', n3, n2)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source2, n3, false);
                if (tag == null || !tag.includeInSearch()) continue;
                return tag;
            } while (++n3 < source2.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static final Tag getPreviousTag(Source source2, int n, TagType tagType) {
        if (tagType == null) {
            return Tag.getPreviousTag(source2, n);
        }
        if (source2.useSpecialTypesCache) {
            return source2.cache.getPreviousTag(n, tagType);
        }
        return Tag.getPreviousTagUncached(source2, n, tagType, -1);
    }

    static final Tag getNextTag(Source source2, int n, TagType tagType) {
        if (tagType == null) {
            return Tag.getNextTag(source2, n);
        }
        if (source2.useSpecialTypesCache) {
            return source2.cache.getNextTag(n, tagType);
        }
        return Tag.getNextTagUncached(source2, n, tagType, -1);
    }

    static final Tag getPreviousTagUncached(Source source2, int n, TagType tagType, int n2) {
        if (tagType == null) {
            return Tag.getPreviousTagUncached(source2, n, n2);
        }
        String string = tagType.getStartDelimiter();
        ParseText parseText = source2.getParseText();
        int n3 = n;
        do {
            if ((n3 = parseText.lastIndexOf(string, n3, n2)) == -1) {
                return null;
            }
            Tag tag = Tag.getTagAt(source2, n3, false);
            if (tag == null || tag.getTagType() != tagType) continue;
            return tag;
        } while (--n3 >= 0);
        return null;
    }

    static final Tag getNextTagUncached(Source source2, int n, TagType tagType, int n2) {
        if (tagType == null) {
            return Tag.getNextTagUncached(source2, n, n2);
        }
        String string = tagType.getStartDelimiter();
        try {
            ParseText parseText = source2.getParseText();
            int n3 = n;
            do {
                if ((n3 = parseText.indexOf(string, n3, n2)) == -1) {
                    return null;
                }
                Tag tag = Tag.getTagAt(source2, n3, false);
                if (tag == null || tag.getTagType() != tagType) continue;
                return tag;
            } while (++n3 < source2.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    static final Tag getTagAt(Source source2, int n, boolean bl) {
        return source2.useAllTypesCache ? source2.cache.getTagAt(n, bl) : Tag.getTagAtUncached(source2, n, bl);
    }

    static final Tag getTagAtUncached(Source source2, int n, boolean bl) {
        return TagType.getTagAt(source2, n, bl, false);
    }

    static final Tag[] parseAll(Source source2, boolean bl) {
        int n;
        Object object;
        Tag[] tagArray;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        source2.fullSequentialParseData = new int[1];
        if (source2.end != 0) {
            tagArray = source2.getParseText();
            object = Tag.parseAllgetNextTag(source2, (ParseText)tagArray, 0, bl);
            while (object != null) {
                arrayList.add((Tag)object);
                if (!object.isUnregistered()) {
                    ++n2;
                    if (object instanceof StartTag) {
                        ++n3;
                    }
                }
                int n4 = n = object.getTagType() == StartTagType.SERVER_COMMON_COMMENT || bl && !object.isUnregistered() ? object.end : object.begin + 1;
                if (n == source2.end) break;
                object = Tag.parseAllgetNextTag(source2, (ParseText)tagArray, n, bl);
            }
        }
        tagArray = new Tag[n2];
        object = new StartTag[n3];
        source2.cache.loadAllTags((List<Tag>)arrayList, tagArray, (StartTag[])object);
        source2.allTagsArray = tagArray;
        source2.allTags = Arrays.asList(tagArray);
        source2.allStartTags = Arrays.asList(object);
        n = tagArray.length - 1;
        for (int j = 0; j < tagArray.length; ++j) {
            Tag tag = tagArray[j];
            tag.previousTag = j > 0 ? tagArray[j - 1] : null;
            tag.nextTag = j < n ? tagArray[j + 1] : null;
        }
        return tagArray;
    }

    private static final Tag parseAllgetNextTag(Source source2, ParseText parseText, int n, boolean bl) {
        try {
            int n2 = n;
            do {
                if ((n2 = parseText.indexOf('<', n2)) == -1) {
                    return null;
                }
                Tag tag = TagType.getTagAt(source2, n2, false, bl);
                if (tag == null) continue;
                if (!bl) {
                    TagType tagType = tag.getTagType();
                    if (tag.end > source2.fullSequentialParseData[0] && tagType != StartTagType.DOCTYPE_DECLARATION && tagType != StartTagType.UNREGISTERED && tagType != EndTagType.UNREGISTERED) {
                        source2.fullSequentialParseData[0] = tagType == StartTagType.NORMAL && tag.name == "script" && !((StartTag)tag).isEmptyElementTag() ? Integer.MAX_VALUE : tag.end;
                    }
                }
                return tag;
            } while (++n2 < source2.end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    void orphan() {
        this.nextTag = NOT_CACHED;
    }

    boolean isOrphaned() {
        return this.source.wasFullSequentialParseCalled() && this.nextTag == NOT_CACHED;
    }
}

