/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.EndTagType;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Logger;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StartTagType;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Tag;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.TagTypeRegister;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public abstract class TagType {
    private final String description;
    private final String startDelimiter;
    private final String closingDelimiter;
    private final boolean isServerTag;
    private final String namePrefix;
    final String startDelimiterPrefix;
    private static Logger logger = null;

    TagType(String string, String string2, String string3, boolean bl, String string4) {
        this.description = string;
        this.startDelimiter = string2;
        this.closingDelimiter = string3;
        this.isServerTag = bl;
        this.namePrefix = string2.substring(string4.length());
        this.startDelimiterPrefix = string4;
    }

    public final void register() {
        TagType.getLogger().debug("Register tag type: " + this);
        TagTypeRegister.add(this);
    }

    public final void deregister() {
        TagType.getLogger().debug("Deregister tag type " + this);
        TagTypeRegister.remove(this);
    }

    public static final List<TagType> getRegisteredTagTypes() {
        return TagTypeRegister.getList();
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getStartDelimiter() {
        return this.startDelimiter;
    }

    public final String getClosingDelimiter() {
        return this.closingDelimiter;
    }

    public final boolean isServerTag() {
        return this.isServerTag;
    }

    protected final String getNamePrefix() {
        return this.namePrefix;
    }

    protected boolean isValidPosition(Source source2, int n, int[] nArray) {
        TagType[] tagTypeArray;
        if (this.isServerTag()) {
            if (nArray != null) {
                return true;
            }
            return !StartTagType.SERVER_COMMON_COMMENT.tagEncloses(source2, n);
        }
        if (nArray != null) {
            if (nArray[0] == Integer.MAX_VALUE) {
                if (this == EndTagType.NORMAL && source2.getParseText().containsAt("</script", n)) {
                    nArray[0] = n;
                    return true;
                }
                if (this == StartTagType.COMMENT) {
                    // empty if block
                }
                return false;
            }
            return n >= nArray[0];
        }
        for (TagType tagType : tagTypeArray = TagType.getTagTypesIgnoringEnclosedMarkup()) {
            if (this == StartTagType.COMMENT && tagType == StartTagType.COMMENT || !tagType.tagEncloses(source2, n)) continue;
            return false;
        }
        return true;
    }

    public static final TagType[] getTagTypesIgnoringEnclosedMarkup() {
        return TagTypesIgnoringEnclosedMarkup.array;
    }

    public static final void setTagTypesIgnoringEnclosedMarkup(TagType[] tagTypeArray) {
        if (tagTypeArray == null) {
            throw new IllegalArgumentException();
        }
        TagTypesIgnoringEnclosedMarkup.array = tagTypeArray;
    }

    protected abstract Tag constructTagAt(Source var1, int var2);

    protected final boolean tagEncloses(Source source2, int n) {
        if (n == 0) {
            return false;
        }
        Tag tag = source2.getEnclosingTag(n - 1, this);
        return tag != null && n != tag.getEnd();
    }

    public String toString() {
        return this.getDescription();
    }

    static final Tag getTagAt(Source source2, int n, boolean bl, boolean bl2) {
        TagTypeRegister.ProspectiveTagTypeIterator prospectiveTagTypeIterator = new TagTypeRegister.ProspectiveTagTypeIterator(source2, n);
        while (prospectiveTagTypeIterator.hasNext()) {
            TagType tagType = prospectiveTagTypeIterator.next();
            if (bl && !tagType.isServerTag() || !bl2 && !tagType.isValidPosition(source2, n, source2.fullSequentialParseData)) continue;
            try {
                Tag tag = tagType.constructTagAt(source2, n);
                if (tag == null) continue;
                return tag;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!source2.logger.isErrorEnabled()) continue;
                source2.logger.error(source2.getRowColumnVector(n).appendTo(new StringBuilder(200).append("Tag at ")).append(" not recognised as type '").append(tagType.getDescription()).append("' because it has no end delimiter").toString());
            }
        }
        return null;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = Source.newLogger();
        }
        return logger;
    }

    @ApiStatus.Internal
    @Generated
    @RelocatedClass
    @SuppressFBWarnings
    private static final class TagTypesIgnoringEnclosedMarkup {
        public static TagType[] array = new TagType[]{StartTagType.COMMENT, StartTagType.CDATA_SECTION};

        private TagTypesIgnoringEnclosedMarkup() {
        }
    }
}

