/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.nonapi.io.github.classgraph.utils.FileUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public final class FastPathResolver {
    private static final Pattern percentMatcher = Pattern.compile("([%][0-9a-fA-F][0-9a-fA-F])+");
    private static final Pattern schemeTwoSlashMatcher = Pattern.compile("^[a-zA-Z+\\-.]+://");
    private static final Pattern schemeOneSlashMatcher = Pattern.compile("^[a-zA-Z+\\-.]+:/");
    private static final boolean WINDOWS = File.separatorChar == '\\';

    private FastPathResolver() {
    }

    private static void translateSeparator(String path, int startIdx, int endIdx, boolean stripFinalSeparator, StringBuilder buf) {
        for (int i2 = startIdx; i2 < endIdx; ++i2) {
            char c = path.charAt(i2);
            if (c == '\\' || c == '/') {
                int prevChar;
                if (i2 >= endIdx - 1 && stripFinalSeparator) continue;
                int n = prevChar = buf.length() == 0 ? 0 : (int)buf.charAt(buf.length() - 1);
                if (prevChar == 47) continue;
                buf.append('/');
                continue;
            }
            buf.append(c);
        }
    }

    private static int hexCharToInt(char c) {
        return c >= '0' && c <= '9' ? c - 48 : (c >= 'a' && c <= 'f' ? c - 97 + 10 : c - 65 + 10);
    }

    private static void unescapePercentEncoding(String path, int startIdx, int endIdx, StringBuilder buf) {
        if (endIdx - startIdx == 3 && path.charAt(startIdx + 1) == '2' && path.charAt(startIdx + 2) == '0') {
            buf.append(' ');
        } else {
            byte[] bytes = new byte[(endIdx - startIdx) / 3];
            int i2 = startIdx;
            int j = 0;
            while (i2 < endIdx) {
                char c1 = path.charAt(i2 + 1);
                char c2 = path.charAt(i2 + 2);
                int digit1 = FastPathResolver.hexCharToInt(c1);
                int digit2 = FastPathResolver.hexCharToInt(c2);
                bytes[j] = (byte)(digit1 << 4 | digit2);
                i2 += 3;
                ++j;
            }
            String str = new String(bytes, StandardCharsets.UTF_8);
            str = str.replace("/", "%2F").replace("\\", "%5C");
            buf.append(str);
        }
    }

    public static String normalizePath(String path, boolean isFileOrJarURL) {
        int prevEndMatchIdx;
        boolean hasPercent;
        boolean bl = hasPercent = path.indexOf(37) >= 0;
        if (!hasPercent && path.indexOf(92) < 0 && !path.endsWith("/")) {
            return path;
        }
        int len = path.length();
        StringBuilder buf = new StringBuilder();
        if (hasPercent && isFileOrJarURL) {
            prevEndMatchIdx = 0;
            Matcher matcher = percentMatcher.matcher(path);
            while (matcher.find()) {
                int startMatchIdx = matcher.start();
                int endMatchIdx = matcher.end();
                FastPathResolver.translateSeparator(path, prevEndMatchIdx, startMatchIdx, false, buf);
                FastPathResolver.unescapePercentEncoding(path, startMatchIdx, endMatchIdx, buf);
                prevEndMatchIdx = endMatchIdx;
            }
        } else {
            FastPathResolver.translateSeparator(path, 0, len, true, buf);
            return buf.toString();
        }
        FastPathResolver.translateSeparator(path, prevEndMatchIdx, len, true, buf);
        return buf.toString();
    }

    public static String resolve(String resolveBasePath, String relativePath2) {
        String pathStr;
        if (relativePath2 == null || relativePath2.isEmpty()) {
            return resolveBasePath == null ? "" : resolveBasePath;
        }
        String prefix = "";
        boolean isAbsolutePath = false;
        boolean isFileOrJarURL = false;
        int startIdx = 0;
        if (relativePath2.regionMatches(true, 0, "jar:", 0, 4)) {
            startIdx = 4;
            isFileOrJarURL = true;
        }
        if (relativePath2.regionMatches(true, startIdx, "http://", 0, 7)) {
            startIdx += 7;
            prefix = "http://";
            isAbsolutePath = true;
        } else if (relativePath2.regionMatches(true, startIdx, "https://", 0, 8)) {
            startIdx += 8;
            prefix = "https://";
            isAbsolutePath = true;
        } else if (relativePath2.regionMatches(true, startIdx, "jrt:", 0, 5)) {
            startIdx += 4;
            prefix = "jrt:";
            isAbsolutePath = true;
        } else if (relativePath2.regionMatches(true, startIdx, "file:", 0, 5)) {
            startIdx += 5;
            isFileOrJarURL = true;
        } else {
            String relPath = startIdx == 0 ? relativePath2 : relativePath2.substring(startIdx);
            Matcher m2 = schemeTwoSlashMatcher.matcher(relPath);
            if (m2.find()) {
                String m2Match = m2.group();
                startIdx += m2Match.length();
                prefix = m2Match;
                isAbsolutePath = true;
            } else {
                Matcher m1 = schemeOneSlashMatcher.matcher(relPath);
                if (m1.find()) {
                    String m1Match = m1.group();
                    startIdx += m1Match.length();
                    prefix = m1Match;
                    isAbsolutePath = true;
                }
            }
        }
        if (isFileOrJarURL) {
            if (WINDOWS) {
                if (relativePath2.startsWith("\\\\\\\\", startIdx) || relativePath2.startsWith("////", startIdx)) {
                    startIdx += 4;
                    prefix = prefix + "//";
                    isAbsolutePath = true;
                } else if (relativePath2.startsWith("\\\\", startIdx)) {
                    startIdx += 2;
                }
            }
            if (relativePath2.startsWith("///", startIdx)) {
                startIdx += 2;
            }
        }
        if (WINDOWS) {
            if (relativePath2.startsWith("//", startIdx) || relativePath2.startsWith("\\\\", startIdx)) {
                startIdx += 2;
                prefix = "//";
                isAbsolutePath = true;
            } else if (relativePath2.length() - startIdx > 2 && Character.isLetter(relativePath2.charAt(startIdx)) && relativePath2.charAt(startIdx + 1) == ':') {
                isAbsolutePath = true;
            } else if (relativePath2.length() - startIdx > 3 && (relativePath2.charAt(startIdx) == '/' || relativePath2.charAt(startIdx) == '\\') && Character.isLetter(relativePath2.charAt(startIdx + 1)) && relativePath2.charAt(startIdx + 2) == ':') {
                isAbsolutePath = true;
                ++startIdx;
            }
        }
        if (relativePath2.length() - startIdx > 1 && (relativePath2.charAt(startIdx) == '/' || relativePath2.charAt(startIdx) == '\\')) {
            isAbsolutePath = true;
        }
        if (!(pathStr = FastPathResolver.normalizePath(startIdx == 0 ? relativePath2 : relativePath2.substring(startIdx), isFileOrJarURL)).equals("/")) {
            if (pathStr.endsWith("/")) {
                pathStr = pathStr.substring(0, pathStr.length() - 1);
            }
            if (pathStr.endsWith("!")) {
                pathStr = pathStr.substring(0, pathStr.length() - 1);
            }
            if (pathStr.endsWith("/")) {
                pathStr = pathStr.substring(0, pathStr.length() - 1);
            }
            if (pathStr.isEmpty()) {
                pathStr = "/";
            }
        }
        String pathResolved = isAbsolutePath || resolveBasePath == null || resolveBasePath.isEmpty() ? FileUtils.sanitizeEntryPath(pathStr, false, true) : FileUtils.sanitizeEntryPath(resolveBasePath + (resolveBasePath.endsWith("/") ? "" : "/") + pathStr, false, true);
        return prefix.isEmpty() ? pathResolved : prefix + pathResolved;
    }

    public static String resolve(String pathStr) {
        return FastPathResolver.resolve(null, pathStr);
    }
}

