/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.dsl.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import name.remal.EscapingKt;
import name.remal.Kotlin_CharSequenceKt;
import name.remal.gradle_plugins.dsl.utils.DependencyNotation;
import name.remal.gradle_plugins.dsl.utils.DependencyNotationKt;
import name.remal.gradle_plugins.dsl.utils.InvalidDependencyNotationPattern;
import name.remal.gradle_plugins.dsl.utils.InvalidDependencyNotationString;
import name.remal.version.Version;
import name.remal.version.VersionRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\f\u0010\u001b\u001a\u00020\b*\u00020\u0003H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lname/remal/gradle_plugins/dsl/utils/DependencyNotationMatcher;", "", "pattern", "", "(Ljava/lang/String;)V", "classifier", "extension", "groupRegex", "Lkotlin/text/Regex;", "moduleRegex", "getPattern", "()Ljava/lang/String;", "version", "versionRange", "Lname/remal/version/VersionRange;", "compareTo", "", "other", "equals", "", "", "hashCode", "matches", "notation", "Lname/remal/gradle_plugins/dsl/utils/DependencyNotation;", "notMatches", "toString", "createRegex", "gradle-plugins-kotlin-dsl"})
public final class DependencyNotationMatcher
implements Comparable<DependencyNotationMatcher> {
    private final Regex groupRegex;
    private final Regex moduleRegex;
    private final String version;
    private final VersionRange versionRange;
    private final String classifier;
    private final String extension;
    @NotNull
    private final String pattern;

    private final Regex createRegex(@NotNull String $receiver) {
        return new Regex(StringsKt.replace$default((String)EscapingKt.escapeRegex((String)$receiver), (String)"\\*", (String)".*", (boolean)false, (int)4, null));
    }

    public final boolean matches(@NotNull DependencyNotation notation2) {
        Version parsedVersion2;
        Intrinsics.checkParameterIsNotNull((Object)notation2, (String)"notation");
        if (!this.groupRegex.matches((CharSequence)notation2.getGroup())) {
            return false;
        }
        if (!this.moduleRegex.matches((CharSequence)notation2.getModule())) {
            return false;
        }
        if (this.version != null && Intrinsics.areEqual((Object)this.version, (Object)notation2.getVersion()) ^ true) {
            return false;
        }
        if (!(this.versionRange == null || (parsedVersion2 = notation2.getParsedVersion()) != null && this.versionRange.contains(parsedVersion2))) {
            return false;
        }
        if (this.classifier != null && Intrinsics.areEqual((Object)this.classifier, (Object)notation2.getClassifier()) ^ true) {
            return false;
        }
        return this.extension == null || !(Intrinsics.areEqual((Object)this.extension, (Object)notation2.getExtension()) ^ true);
    }

    public final boolean matches(@NotNull String notation2) {
        Intrinsics.checkParameterIsNotNull((Object)notation2, (String)"notation");
        return this.matches(DependencyNotationKt.parseDependencyNotation(notation2));
    }

    public final boolean notMatches(@NotNull DependencyNotation notation2) {
        Intrinsics.checkParameterIsNotNull((Object)notation2, (String)"notation");
        return !this.matches(notation2);
    }

    public final boolean notMatches(@NotNull String notation2) {
        Intrinsics.checkParameterIsNotNull((Object)notation2, (String)"notation");
        return !this.matches(DependencyNotationKt.parseDependencyNotation(notation2));
    }

    @NotNull
    public String toString() {
        return this.pattern;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DependencyNotationMatcher && Intrinsics.areEqual((Object)this.pattern, (Object)((DependencyNotationMatcher)other).pattern);
    }

    public int hashCode() {
        return 1 + this.pattern.hashCode();
    }

    @Override
    public int compareTo(@NotNull DependencyNotationMatcher other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.pattern.compareTo(other.pattern);
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    public DependencyNotationMatcher(@NotNull String pattern) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        try {
            object = DependencyNotationKt.parseDependencyNotation(this.pattern);
        }
        catch (InvalidDependencyNotationString e) {
            throw (Throwable)new InvalidDependencyNotationPattern(this.pattern, e);
        }
        DependencyNotation patternNotation = object;
        String string = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)patternNotation.getGroup());
        if (string == null || (string = this.createRegex(string)) == null) {
            throw (Throwable)new InvalidDependencyNotationPattern("Empty group: " + this.pattern);
        }
        this.groupRegex = string;
        String string2 = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)patternNotation.getModule());
        if (string2 == null || (string2 = this.createRegex(string2)) == null) {
            throw (Throwable)new InvalidDependencyNotationPattern("Empty module: " + this.pattern);
        }
        this.moduleRegex = string2;
        object = patternNotation.getVersion();
        if (object.length() > 0) {
            if (StringsKt.contains$default((CharSequence)patternNotation.getVersion(), (char)'*', (boolean)false, (int)2, null)) {
                throw (Throwable)new InvalidDependencyNotationPattern("Don't use '*' for version range, use '+' instead: " + this.pattern);
            }
            if (StringsKt.contains$default((CharSequence)patternNotation.getVersion(), (char)'+', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)patternNotation.getVersion(), (char)'[', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)patternNotation.getVersion(), (char)']', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)patternNotation.getVersion(), (char)'(', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)patternNotation.getVersion(), (char)')', (boolean)false, (int)2, null)) {
                this.version = null;
                DependencyNotationMatcher dependencyNotationMatcher = this;
                try {
                    DependencyNotationMatcher dependencyNotationMatcher2 = dependencyNotationMatcher;
                    object = VersionRange.parse((String)patternNotation.getVersion());
                }
                catch (Exception e) {
                    DependencyNotationMatcher dependencyNotationMatcher3 = dependencyNotationMatcher;
                    throw (Throwable)new InvalidDependencyNotationPattern("Invalid version: " + this.pattern, e);
                }
                dependencyNotationMatcher2.versionRange = object;
            } else {
                this.version = patternNotation.getVersion();
                this.versionRange = null;
            }
        } else {
            this.version = null;
            this.versionRange = null;
        }
        this.classifier = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)patternNotation.getClassifier());
        this.extension = (String)Kotlin_CharSequenceKt.nullIfEmpty((CharSequence)patternNotation.getExtension());
    }
}

