/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import name.remal.gradle_plugins.dsl.internal.Generated;
import name.remal.gradle_plugins.dsl.internal.RelocatedClass;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Attributes;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.AttributesOutputSegment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.BlankOutputSegment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.CharOutputSegment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.CharStreamSource;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.CharStreamSourceUtil;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Config;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.FormControl;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.FormFields;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.OutputSegment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.ParseText;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.RemoveOutputSegment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Segment;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.Source;
import name.remal.gradle_plugins_kotlin_dsl.internal._relocated.net.htmlparser.jericho.StringOutputSegment;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Generated
@RelocatedClass
@SuppressFBWarnings
public final class OutputDocument
implements CharStreamSource {
    private CharSequence sourceText;
    private ArrayList<OutputSegment> outputSegments = new ArrayList();
    private final Segment segment;

    public OutputDocument(Source source2) {
        if (source2 == null) {
            throw new IllegalArgumentException("source argument must not be null");
        }
        this.segment = source2;
        this.sourceText = source2;
    }

    public OutputDocument(Segment segment) {
        if (segment == null) {
            throw new IllegalArgumentException("segment argument must not be null");
        }
        this.segment = segment;
        Source source2 = segment.source;
        this.sourceText = source2;
        if (segment.begin > 0) {
            this.remove(0, segment.begin);
        }
        if (segment.end < source2.end) {
            this.remove(segment.end, source2.end);
        }
    }

    OutputDocument(ParseText parseText) {
        this.sourceText = parseText;
        this.segment = null;
    }

    public Segment getSegment() {
        return this.segment;
    }

    public CharSequence getSourceText() {
        return this.sourceText;
    }

    public void remove(int n, int n2) {
        this.register(new RemoveOutputSegment(n, n2));
    }

    public void remove(Segment segment) {
        this.register(new RemoveOutputSegment(segment));
    }

    public void remove(Collection<? extends Segment> collection) {
        for (Segment segment : collection) {
            this.remove(segment);
        }
    }

    public void insert(int n, CharSequence charSequence) {
        this.register(new StringOutputSegment(n, n, charSequence));
    }

    public void replace(Segment segment, CharSequence charSequence) {
        this.replace(segment.getBegin(), segment.getEnd(), charSequence);
    }

    public void replace(int n, int n2, CharSequence charSequence) {
        this.register(new StringOutputSegment(n, n2, charSequence));
    }

    public void replace(int n, int n2, char c) {
        this.register(new CharOutputSegment(n, n2, c));
    }

    public void replace(FormControl formControl) {
        formControl.replaceInOutputDocument(this);
    }

    public void replace(FormFields formFields) {
        formFields.replaceInOutputDocument(this);
    }

    public Map<String, String> replace(Attributes attributes2, boolean bl) {
        AttributesOutputSegment attributesOutputSegment = new AttributesOutputSegment(attributes2, bl);
        this.register(attributesOutputSegment);
        return attributesOutputSegment.getMap();
    }

    public void replace(Attributes attributes2, Map<String, String> map2) {
        this.register(new AttributesOutputSegment(attributes2, map2));
    }

    public void replaceWithSpaces(int n, int n2) {
        this.register(new BlankOutputSegment(n, n2));
    }

    public void register(OutputSegment outputSegment) {
        this.outputSegments.add(outputSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(Writer writer) throws IOException {
        try {
            this.appendTo(writer);
        }
        finally {
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer, int n, int n2) throws IOException {
        try {
            this.appendTo(writer, n, n2);
        }
        finally {
            writer.flush();
        }
    }

    @Override
    public void appendTo(Appendable appendable) throws IOException {
        this.appendTo(appendable, 0, this.sourceText.length());
    }

    public void appendTo(Appendable appendable, int n, int n2) throws IOException {
        if (this.outputSegments.isEmpty()) {
            appendable.append(this.sourceText, n, n2);
            return;
        }
        int n3 = n;
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        for (OutputSegment outputSegment : this.outputSegments) {
            if (outputSegment.getEnd() < n3 || outputSegment.getEnd() == n3 && outputSegment.getBegin() < n3) continue;
            if (outputSegment.getBegin() > n2 || outputSegment.getBegin() == n2 && outputSegment.getEnd() > n2) break;
            if (outputSegment.getBegin() > n3) {
                appendable.append(this.sourceText, n3, outputSegment.getBegin());
            }
            if (outputSegment.getBegin() < n3 && outputSegment instanceof BlankOutputSegment) {
                int n4 = outputSegment.getEnd();
                while (n3 < n4) {
                    appendable.append(' ');
                    ++n3;
                }
                continue;
            }
            outputSegment.appendTo(appendable);
            n3 = outputSegment.getEnd();
        }
        if (n3 < n2) {
            appendable.append(this.sourceText, n3, n2);
        }
    }

    @Override
    public long getEstimatedMaximumOutputLength() {
        long l = this.sourceText.length();
        for (OutputSegment outputSegment : this.outputSegments) {
            int n = outputSegment.getEnd() - outputSegment.getBegin();
            l += outputSegment.getEstimatedMaximumOutputLength() - (long)n;
        }
        return l >= 0L ? l : -1L;
    }

    @Override
    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public String getDebugInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        for (OutputSegment outputSegment : this.getRegisteredOutputSegments()) {
            CharSequence charSequence;
            if (outputSegment instanceof BlankOutputSegment) {
                stringBuilder.append("Replace with Spaces: ");
            } else if (outputSegment instanceof RemoveOutputSegment) {
                stringBuilder.append("Remove: ");
            } else {
                stringBuilder.append("Replace: ");
            }
            if (this.sourceText instanceof Source) {
                charSequence = (Source)this.sourceText;
                stringBuilder.append('(');
                ((Source)charSequence).getRowColumnVector(outputSegment.getBegin()).appendTo(stringBuilder);
                stringBuilder.append('-');
                ((Source)charSequence).getRowColumnVector(outputSegment.getEnd()).appendTo(stringBuilder);
                stringBuilder.append(')');
            } else {
                stringBuilder.append("(p").append(outputSegment.getBegin()).append("-p").append(outputSegment.getEnd()).append(')');
            }
            stringBuilder.append(' ');
            charSequence = outputSegment.toString();
            if (((String)charSequence).length() <= 20) {
                stringBuilder.append((String)charSequence);
            } else {
                stringBuilder.append(((String)charSequence).substring(0, 20)).append("...");
            }
            stringBuilder.append(Config.NewLine);
        }
        return stringBuilder.toString();
    }

    public List<OutputSegment> getRegisteredOutputSegments() {
        Collections.sort(this.outputSegments, OutputSegment.COMPARATOR);
        return this.outputSegments;
    }
}

