/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.dsl.cache;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import name.remal.Java_io_FileKt;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u0000 #*\b\b\u0000\u0010\u0001*\u0002H\u0002*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001#B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ-\u0010\u001a\u001a\u00020\u001b2%\u0010\u001c\u001a!\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u001d\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u000eJ\r\u0010\u001e\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0005H\u0016J\u0015\u0010!\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\"R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR/\u0010\r\u001a\u001f\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R/\u0010\u0015\u001a\u001f\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u0010\u0012\b\b\u0011\u0012\u0004\b\b(\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006$"}, d2={"Lname/remal/gradle_plugins/dsl/cache/BaseCache;", "ReadValueType", "WriteValueType", "", "cacheId", "", "version", "", "(Ljava/lang/String;I)V", "cacheFile", "Ljava/io/File;", "getCacheId", "()Ljava/lang/String;", "deserializer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "bytes", "getDeserializer", "()Lkotlin/jvm/functions/Function1;", "serializer", "value", "getSerializer", "getVersion", "()I", "compute", "", "func", "currentValue", "read", "()Ljava/lang/Object;", "toString", "write", "(Ljava/lang/Object;)V", "Companion", "gradle-plugins-kotlin-dsl"})
public abstract class BaseCache<ReadValueType extends WriteValueType, WriteValueType> {
    private final File cacheFile;
    @NotNull
    private final String cacheId;
    private final int version;
    @NotNull
    private static final File baseCacheDir;
    private static final Regex CACHE_ID_REGEX;
    public static final Companion Companion;

    @NotNull
    protected abstract Function1<WriteValueType, byte[]> getSerializer();

    @NotNull
    protected abstract Function1<byte[], ReadValueType> getDeserializer();

    public final void write(@Nullable WriteValueType value) {
        byte[] bytes;
        byte[] byArray;
        WriteValueType WriteValueType = value;
        if (WriteValueType != null) {
            WriteValueType WriteValueType2 = WriteValueType;
            Function1<WriteValueType, byte[]> function1 = this.getSerializer();
            byArray = (byte[])function1.invoke(WriteValueType2);
        } else {
            byArray = bytes = null;
        }
        if (bytes == null) {
            Java_io_FileKt.forceDeleteRecursively((File)this.cacheFile);
        } else {
            Java_io_FileKt.lockAndWriteBytes$default((File)this.cacheFile, (byte[])bytes, null, (int)2, null);
        }
    }

    @Nullable
    public final ReadValueType read() {
        if (this.cacheFile.exists()) {
            byte[] bytes = Java_io_FileKt.lockAndReadBytes$default((File)this.cacheFile, null, (int)1, null);
            Object value = this.getDeserializer().invoke((Object)bytes);
            return (ReadValueType)value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void compute(@NotNull Function1<? super ReadValueType, ? extends WriteValueType> func) {
        Intrinsics.checkParameterIsNotNull(func, (String)"func");
        BaseCache baseCache = this;
        synchronized (baseCache) {
            boolean bl = false;
            Java_io_FileKt.forLockedFileChannel$default((File)this.cacheFile, null, null, (Function1)((Function1)new Function1<FileChannel, Unit>(this, func){
                final /* synthetic */ BaseCache this$0;
                final /* synthetic */ Function1 $func$inlined;
                {
                    this.this$0 = baseCache;
                    this.$func$inlined = function1;
                    super(1);
                }

                public final void invoke(@NotNull FileChannel channel) {
                    byte[] bytes;
                    byte[] byArray;
                    Object value;
                    Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                    ReadValueType currentValue = this.this$0.read();
                    Object object = value = this.$func$inlined.invoke(currentValue);
                    if (object != null) {
                        Object object2 = object;
                        Function1<WriteValueType, byte[]> function1 = this.this$0.getSerializer();
                        byArray = (byte[])function1.invoke(object2);
                    } else {
                        byArray = bytes = null;
                    }
                    if (bytes == null) {
                        Java_io_FileKt.forceDeleteRecursively((File)BaseCache.access$getCacheFile$p(this.this$0));
                    } else {
                        channel.write(ByteBuffer.wrap(bytes));
                    }
                }
            }), (int)3, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.cacheId + '/' + this.version + ']';
    }

    @NotNull
    protected final String getCacheId() {
        return this.cacheId;
    }

    protected final int getVersion() {
        return this.version;
    }

    public BaseCache(@NotNull String cacheId, int version) {
        String string;
        String fileName;
        int extPos;
        Intrinsics.checkParameterIsNotNull((Object)cacheId, (String)"cacheId");
        this.cacheId = cacheId;
        this.version = version;
        CharSequence charSequence = this.cacheId;
        Regex regex2 = CACHE_ID_REGEX;
        if (!regex2.matches(charSequence)) {
            throw (Throwable)new IllegalArgumentException("Cache ID '" + this.cacheId + "' doesn't match to '" + CACHE_ID_REGEX + "' regex");
        }
        if (this.version <= 0) {
            throw (Throwable)new IllegalArgumentException("version <= 0: " + this.version);
        }
        File file2 = baseCacheDir;
        BaseCache baseCache = this;
        CharSequence $receiver = charSequence = new StringBuilder();
        boolean bl = false;
        if (StringsKt.contains$default((CharSequence)this.cacheId, (char)'/', (boolean)false, (int)2, null)) {
            ((StringBuilder)$receiver).append(StringsKt.substringBeforeLast$default((String)this.cacheId, (char)'/', null, (int)2, null)).append('/');
        }
        if (0 <= (extPos = StringsKt.lastIndexOf$default((CharSequence)(fileName = StringsKt.substringAfterLast$default((String)this.cacheId, (char)'/', null, (int)2, null)), (char)'.', (int)0, (boolean)false, (int)6, null))) {
            String string2 = fileName;
            int n = 0;
            CharSequence charSequence2 = $receiver;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, extPos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            ((StringBuilder)charSequence2).append(string5);
            ((StringBuilder)$receiver).append(".").append(this.version);
            string2 = fileName;
            charSequence2 = $receiver;
            String string6 = string2;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(extPos);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            string5 = string7;
            ((StringBuilder)charSequence2).append(string5);
        } else {
            ((StringBuilder)$receiver).append(fileName);
            ((StringBuilder)$receiver).append(".").append(this.version);
        }
        String string8 = ((StringBuilder)charSequence).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"StringBuilder().apply(builderAction).toString()");
        String string9 = string = string8;
        File file3 = file2;
        baseCache.cacheFile = new File(file3, string9);
    }

    static {
        Companion = new Companion(null);
        File file2 = new File(GradleUserHomeLookup.gradleUserHome(), "caches/remal-gradle-plugins").getAbsoluteFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"File(gradleUserHome(), \"\u2026le-plugins\").absoluteFile");
        baseCacheDir = file2;
        CACHE_ID_REGEX = new Regex("[\\w./-]+");
    }

    public static final /* synthetic */ File access$getCacheFile$p(BaseCache $this) {
        return $this.cacheFile;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lname/remal/gradle_plugins/dsl/cache/BaseCache$Companion;", "", "()V", "CACHE_ID_REGEX", "Lkotlin/text/Regex;", "baseCacheDir", "Ljava/io/File;", "getBaseCacheDir", "()Ljava/io/File;", "gradle-plugins-kotlin-dsl"})
    public static final class Companion {
        @NotNull
        protected final File getBaseCacheDir() {
            return baseCacheDir;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

